% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/align-group.R
\name{align_group}
\alias{align_group}
\title{Group and align layout based on categorical or factor levels.}
\usage{
align_group(group, set_context = FALSE, name = NULL)
}
\arguments{
\item{group}{A character define the groups, this will split the
axis into different panel.}

\item{set_context}{A single boolean value indicates whether to set the active
context to current plot. If \code{TRUE}, all subsequent ggplot elements will be
added into this plot.}

\item{name}{A string of the plot name. Used to switch the active context in
\code{\link[=hmanno]{hmanno()}} or \code{\link[=stack_active]{stack_active()}}.}
}
\value{
A new \code{Align} object.
}
\description{
Group and align layout based on categorical or factor levels.
}
\examples{
small_mat <- matrix(rnorm(81), nrow = 9)
ggheatmap(small_mat) +
    hmanno("top") +
    align_group(sample(letters[1:4], ncol(small_mat), replace = TRUE))
}
