% Generated by roxygen2 (4.0.2): do not edit by hand
\name{plot.gg_interaction}
\alias{plot.gg_interaction}
\title{plot.gg_interaction
Plot a \code{\link{gg_interaction}} object,}
\usage{
\method{plot}{gg_interaction}(x, x_var, lbls, ...)
}
\arguments{
\item{x}{gg_interaction object created from a \code{randomForestSRC::rfsrc} object}

\item{x_var}{variable (or list of variables) of interest.}

\item{lbls}{A vector of alternative variable names.}

\item{...}{arguments passed to the \code{\link{gg_interaction}} function.}
}
\value{
\code{ggplot} object
}
\description{
plot.gg_interaction
Plot a \code{\link{gg_interaction}} object,
}
\examples{
\dontrun{
#' ## Examples from randomForestSRC package...
## ------------------------------------------------------------
## find interactions, classification setting
## ------------------------------------------------------------
## iris.obj <- rfsrc(Species ~., data = iris)
## TODO: VIMP interactions not handled yet....
## find.interaction(iris.obj, method = "vimp", nrep = 3)
## iris_interaction <- find.interaction(iris.obj)
data(iris_interaction, package="ggRandomForests")
gg_dta <- gg_interaction(iris_interaction)

plot(gg_dta, x_var="Petal.Width")
plot(gg_dta, x_var="Petal.Length")

## ------------------------------------------------------------
## find interactions, regression setting
## ------------------------------------------------------------
## airq.obj <- rfsrc(Ozone ~ ., data = airquality)
##
## TODO: VIMP interactions not handled yet....
## find.interaction(airq.obj, method = "vimp", nrep = 3)
## airq_interaction <- find.interaction(airq.obj)
data(airq_interaction, package="ggRandomForests")
gg_dta <- gg_interaction(airq_interaction)

plot(gg_dta, x_var="Temp")
plot(gg_dta, x_var="Solar.R")

## ------------------------------------------------------------
## find interactions, survival setting
## ------------------------------------------------------------
## data(pbc, package = "randomForestSRC")
## pbc.obj <- rfsrc(Surv(days,status) ~ ., pbc, nsplit = 10)
## pbc_interaction <- find.interaction(pbc.obj, nvar = 8)
data(pbc_interaction, package="ggRandomForests")
gg_dta <- gg_interaction(pbc_interaction)

plot(gg_dta, x_var="bili")
plot(gg_dta, x_var="copper")

plot(gg_dta, x_var=c("bili", "copper", "age", "albumin"), panel=TRUE)

}
}
\references{
Breiman L. (2001). Random forests, Machine Learning, 45:5-32.

Ishwaran H. and Kogalur U.B. (2007). Random survival forests for
R, Rnews, 7(2):25-31.

Ishwaran H. and Kogalur U.B. (2013). Random Forests for Survival,
Regression and Classification (RF-SRC), R package version 1.4.
}
\seealso{
\code{\link{plot.gg_interaction}} \code{randomForestSRC::rfsrc}
\code{randomForestSRC::find.interaction}
\code{randomForestSRC::max.subtree} \code{randomForestSRC::var.select}
\code{randomForestSRC::vimp}
}

