% Generated by roxygen2 (4.0.2): do not edit by hand
\name{plot.gg_error}
\alias{plot.gg_error}
\title{Plot a \code{\link{gg_error}} object}
\usage{
\method{plot}{gg_error}(x, ...)
}
\arguments{
\item{x}{gg_error object created from a randomForestSRC object}

\item{...}{extra arguments}
}
\value{
ggplot graph
}
\description{
A plot of the cumulative OOB error rates of the random forest as a
function of number of trees.
}
\details{
The gg_error plot is used to track the convergence of the
randomForest. This figure is a reproduction of the error plot
from the \code{randomForestSRC::plot.rfsrc} function.
}
\examples{
\dontrun{
#' ## Examples from RFSRC package...
## ------------------------------------------------------------
## classification example
## ------------------------------------------------------------
## You can build a randomForest
# iris_rf <- rfsrc(Species ~ ., data = iris)
# ... or load a cached randomForestSRC object
data(iris_rf, package="ggRandomForests")

# Get a data.frame containing error rates
gg_dta<- gg_error(iris_rf)

# Plot the gg_error object
plot(gg_dta)

## ------------------------------------------------------------
## Regression example
## ------------------------------------------------------------
# airq_rf <- rfsrc(Ozone ~ ., data = airquality, na.action = "na.impute")
# ... or load a cached randomForestSRC object
data(airq_rf, package="ggRandomForests")

# Get a data.frame containing error rates
gg_dta<- gg_error(airq_rf)

# Plot the gg_error object
plot(gg_dta)

## ------------------------------------------------------------
## Survival example
## ------------------------------------------------------------
## veteran data
## randomized trial of two treatment regimens for lung cancer
# data(veteran, package = "randomForestSRC")
# veteran_rf <- rfsrc(Surv(time, status) ~ ., data = veteran, ntree = 100)

# Load a cached randomForestSRC object
data(veteran_rf, package="ggRandomForests")

gg_dta <- gg_error(veteran_rf)
plot(gg_dta)

}
}
\references{
Breiman L. (2001). Random forests, Machine Learning, 45:5-32.

Ishwaran H. and Kogalur U.B. (2007). Random survival forests for R, Rnews,
7(2):25-31.

Ishwaran H. and Kogalur U.B. (2013). Random Forests for Survival, Regression
and Classification (RF-SRC), R package version 1.4.
}
\seealso{
\code{\link{gg_error}} \code{randomForestSRC::rfsrc} \code{randomForestSRC::plot.rfsrc}
}

