% Generated by roxygen2 (4.0.2): do not edit by hand
\name{print.gg_interaction}
\alias{print.gg_interaction}
\title{Print a \code{\link{gg_interaction}} object.}
\usage{
\method{print}{gg_interaction}(x, ...)
}
\arguments{
\item{x}{a \code{\link{gg_interaction}} object.}

\item{...}{optional arguments

We use the tble_df command to print \code{gg_interaction} objects because they
tend to be long (ntree records long).}
}
\description{
Print a \code{\link{gg_interaction}} object.
}
\examples{
## ------------------------------------------------------------
## classification example
## ------------------------------------------------------------
## You can build a randomForest
# iris_rf <- rfsrc(Species ~ ., data = iris)
# iris_interaction <- find.interaction(iris_rf)
#
# ... or load a cached randomForestSRC object
data(iris_interaction, package="ggRandomForests")

# Get a data.frame containing minimaldepth measures
ggrf_int<- gg_interaction(iris_interaction)
print(ggrf_int)

## ------------------------------------------------------------
## regression example
## ------------------------------------------------------------
data(airq_interaction, package="ggRandomForests")

# Get a data.frame containing minimaldepth measures
ggrf_int<- gg_interaction(airq_interaction)
print(ggrf_int)
}
\seealso{
\code{rfsrc} \code{tbl_df} \code{\link{gg_interaction}}
}

