% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gfpop.R
\name{gfpop}
\alias{gfpop}
\title{Graph-Constrained Functional Pruning Optimal Partitioning (gfpop)}
\usage{
gfpop(data, mygraph, type = "mean", weights = NULL, testMode = FALSE)
}
\arguments{
\item{data}{vector of data to segment}

\item{mygraph}{dataframe of class "graph" to constrain the changepoint inference}

\item{type}{a string defining the cost model to use: "mean", "variance", "poisson", "exp", "negbin"}

\item{weights}{vector of weights (positive numbers), same size as data}

\item{testMode}{boolean. False by default. Used to debug the code}
}
\value{
a gfpop object = (changepoints, states, forced, parameters, globalCost)
\describe{
\item{\code{changepoints}}{is the vector of changepoints (we give the last element of each segment)}
\item{\code{states}}{is the vector giving the state of each segment}
\item{\code{forced}}{is the vector specifying whether the constraints of the graph are active (=1) or not (=0)}
\item{\code{parameters}}{is the vector of successive parameters of each segment}
\item{\code{globalCost}}{is a number equal to the total loss: the minimal cost for the optimization problem with all penalty values excluded}
 }
}
\description{
Functional pruning optimal partitioning with a graph structure to take into account constraints on consecutive segment parameters. The user has to specify the graph he wants to use (see the graph function) and a type of cost function. This is the main function of the gfpop package.
}
