% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getSWATcfsr.R
\name{getSWATcfsr}
\alias{getSWATcfsr}
\title{Gets met data from the redimentioned CFSR data set and outputs SWAT IO format weather input files}
\usage{
getSWATcfsr(centroids, outDir = getwd())
}
\arguments{
\item{centroids}{- data.frame object or location of csv file with two columns, the first being lattitude and second being longidute in decimal degrees. These should be the centroids of the swat model subbasins and are the locations of the ouput met data.}

\item{outDir}{- Directory where ouput files will be saved.}
}
\value{
returns cfsr met data in swat IO format
}
\description{
Gets met data from the redimentioned CFSR data set and outputs SWAT IO format weather input files
}
\examples{
\dontrun{
centroids = data.frame(lat = 38, lon = 79)
outDir = "test"
getSWATcfsr(centroids=centroids, outDir=outDir)
}
}

