% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GermValue.R
\name{GermValue}
\alias{GermValue}
\alias{PeakValue}
\title{Peak value and germination value}
\usage{
PeakValue(germ.counts, intervals, total.seeds, partial = TRUE)

GermValue(germ.counts, intervals, total.seeds, partial = TRUE,
  method = c("czabator", "dp"), from.onset = TRUE, k = 10)
}
\arguments{
\item{germ.counts}{Germination counts at each time interval. Can be partial
or cumulative as specified in the argument \code{partial}.}

\item{intervals}{The time intervals.}

\item{total.seeds}{Total number of seeds.}

\item{partial}{logical. If \code{TRUE}, \code{germ.counts} is considered as
partial and if \code{FALSE}, it is considered as cumulative. Default is
\code{TRUE}.}

\item{method}{The method for computing germination value. Either
\code{"czabator"} or \code{"dp"}.}

\item{from.onset}{logical. If \code{TRUE}, duration is considered only from
the onset of germination. If \code{FALSE}, full duration of germination
test is considered. Default is \code{TRUE}.}

\item{k}{Constant (See \strong{Details}). Default is 10.}
}
\value{
A list with the following components:  \item{Germination Value}{The
  germination value} \item{Calculations}{The data frame of calculations.}
  \item{testend}{The end of test value (Only for method \code{dp}).}
}
\description{
Compute the Peak value (\ifelse{html}{\out{<i>PV</i>}}{\eqn{PV}}) or
Emergence Energy (\ifelse{html}{\out{<i>EE</i>}}{\eqn{EE}})
\insertCite{czabator_germination_1962,bonner_ideal_1967}{germinationmetrics}
and Germination value (\ifelse{html}{\out{<i>GV</i>}}{\eqn{GV}})
\insertCite{czabator_germination_1962,djavanshir_germination_1976,brown_representing_1988}{germinationmetrics}.
}
\details{
Peak value (\ifelse{html}{\out{<i>PV</i>}}{\eqn{PV}}) is the maximum quotient
obtained by dividing successive cumulative germination values by the relevant
incubation time \insertCite{czabator_germination_1962}{germinationmetrics}.
It represents the mean daily germination of the most vigorous component of
the seed lot, and is a mathematical expression of the break, or shoulder, of
a typical sigmoid  germination curve
\insertCite{djavanshir_germination_1976}{germinationmetrics}. It is the
accumulated number of seeds germinated at the point on the germination curve
at which the rate of germination starts to decrease. It is also described as
Emergence energy \insertCite{bonner_ideal_1967}{germinationmetrics}.

For daily germination counts, germination value
(\ifelse{html}{\out{<i>GV</i>}}{\eqn{GV}}) is computed as follows
\insertCite{czabator_germination_1962}{germinationmetrics}.

\ifelse{html}{\out{<p style="text-align: center;"><em>GV = PV &times;
MDG</em></p>}}{\deqn{GV = PV \times MDG}}

Where, \ifelse{html}{\out{<i>PV</i>}}{\eqn{PV}} is the peak value and
\ifelse{html}{\out{<i>MDG</i>}}{\eqn{MDG}} is the mean daily germination
percentage from the onset of germination.

Germination value (\ifelse{html}{\out{<i>GV</i>}}{\eqn{GV}}) can also be
computed for other time intervals of successive germination counts, by
replacing \ifelse{html}{\out{<i>MDG</i>}}{\eqn{MDG}} with the mean
germination percentage per unit time (\ifelse{html}{\out{<em><span
style="text-decoration:overline">GP</span></em>}}{\eqn{\overline{GP}}}).

A new estimation of germination value was given by
\insertCite{djavanshir_germination_1976;textual}{germinationmetrics} as
follows:

\ifelse{html}{\out{<p style="text-align: center;"><i>GV =
[<sup>&sum;DGS</sup> &frasl; <sub>N</sub>] &times; GP &times;
k</i></p>}}{\deqn{GV = \frac{\sum DGS}{N} \times GP \times k}}

Where, \ifelse{html}{\out{<i>DGS</i>}}{\eqn{DGS}} is the daily germination
speed computed by dividing cumulative germination percentage by the number of
days since the onset of germination, \ifelse{html}{\out{<i>N</i>}}{\eqn{N}}
is the frequency or number of DGS calculated during the test, \eqn{GP} is the
germination percentage expressed over 100 and
\ifelse{html}{\out{<i>k</i>}}{\eqn{k}} is a constant. The value of
\ifelse{html}{\out{<i>k</i>}}{\eqn{k}} is decided on the basis of average
daily speed of germination (\ifelse{html}{\out{<em><sup>&sum;DGS</sup>
&frasl; <sub>N</sub></em>}}{\eqn{\frac{\sum DGS}{N}}}). If it is less than
10, then \ifelse{html}{\out{<i>k</i>}}{\eqn{k}} value of 10 can be used and
if it is more than 10, then value of 7 or 8 can be used for
\ifelse{html}{\out{<i>k</i>}}{\eqn{k}}.

For both methods of computing \ifelse{html}{\out{<i>GV</i>}}{\eqn{GV}}, only
the duration from the onset of germination is considered by default.
Alternatively, modified \ifelse{html}{\out{<i>GV</i>}}{\eqn{GV}}
(\ifelse{html}{\out{<i>GV</sub>mod<sub></i>}}{\eqn{GV_{mod}}}), where the
entire duration from the beginning of the test is considered can be obtained
by using the argument \code{from.onset = FALSE}
\insertCite{brown_representing_1988}{germinationmetrics}.
}
\examples{

x <- c(0, 0, 34, 40, 21, 10, 4, 5, 3, 5, 8, 7, 7, 6, 6, 4, 0, 2, 0, 2)
y <- c(0, 0, 34, 74, 95, 105, 109, 114, 117, 122, 130, 137, 144, 150,
      156, 160, 160, 162, 162, 164)
int <- 1:length(x)
total.seeds = 200

# From partial germination counts
#----------------------------------------------------------------------------
PeakValue(germ.counts = x, intervals = int, total.seeds = 200)
GermValue(germ.counts = x, intervals = int, total.seeds = 200,
          method = "czabator")
GermValue(germ.counts = x, intervals = int, total.seeds = 200,
          method = "dp", k = 10)
GermValue(germ.counts = x, intervals = int, total.seeds = 200,
          method = "czabator", from.onset = FALSE)
GermValue(germ.counts = x, intervals = int, total.seeds = 200,
          method = "dp", k = 10, from.onset = FALSE)

# From cumulative germination counts
#----------------------------------------------------------------------------
PeakValue(germ.counts = y, interval = int, total.seeds = 200,
          partial = FALSE)
GermValue(germ.counts = y, intervals = int, total.seeds = 200,
          partial = FALSE, method = "czabator")
GermValue(germ.counts = y, intervals = int, total.seeds = 200,
          partial = FALSE, method = "dp", k = 10)
GermValue(germ.counts = y, intervals = int, total.seeds = 200,
          partial = FALSE, method = "czabator", from.onset = FALSE)
GermValue(germ.counts = y, intervals = int, total.seeds = 200,
          partial = FALSE, method = "dp", k = 10, from.onset = FALSE)

}
\references{
\insertAllCited{}
}
