% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_gerbil.R
\name{gof_gerbil}
\alias{gof_gerbil}
\title{Goodness-of-fit testing for \code{gerbil} objects}
\usage{
gof_gerbil(
  x,
  y = NULL,
  type = 1,
  imp = 1,
  breaks = NULL,
  method = c("chi-squared", "fisher", "G"),
  ks = FALSE,
  partial = "imputed",
  ...
)
}
\arguments{
\item{x}{A \code{gerbil} object containing the imputed data.}

\item{y}{A vector listing the column names of the imputed data for which tests should be run. See details. By default, \code{y} contains all columns of the data that required imputation.}

\item{type}{A scalar used to specify the type of tests that will be performed.  Options include univariate (marginal) tests (\code{type = 1}) and bivariate tests (\code{type = 2}). See details. Defaults to \code{type = 1}.}

\item{imp}{A scalar or vector indicating which of the multiply imputed datasets should be used for testing.  Defaults to \code{imp = 1}.}

\item{breaks}{Used to determine the cut-points for binning of continuous variables into categories. Ideally, \code{breaks} is a named list, where the list names are the names of the continuous variables. 
Each element of the list can be a vector giving the respective cutpoints or a scalar which is used to indicate the number of bins (in which case cutpoints are determined from percentiles in order to yield bins of approximately equal size). 
If \code{breaks} is a scalar or a vector (and not a list), the binning strategy indicated by \code{breaks} is applied to each variable in accordance with the description above.  
Defaults to \code{breaks = 4}.}

\item{method}{The type of test that is used to compare contingency tables.  Options include \code{'chi-squared'} for chi-squared testing (the default), \code{'fisher'} for Fisher's exact test, and \code{'G'} for a G-test.}

\item{ks}{If \code{TRUE}, a Kolmogorov-Smirnov test is used when for univariate comparisons with continuous variables.  This functionality is not enabled for bivariate testing.  Defaults to \code{FALSE}.}

\item{partial}{Indicates how partially imputed pairs are handled in bivariate testing. If \code{'imputed'}, cases with at least one missing variable in a pair are considered imputed. Otherwise (\code{partial = 'observed'}), only cases with both variables in the pair missing are considered imputed.}

\item{...}{Arguments to be passed to methods.}
}
\value{
\code{gof_gerbil()} returns an object of the class \code{gof_gerbil} that has following slots:

\describe{
        \item{Stats}{A vector (when \code{type = 1}) or matrix (when \code{type = 2}) giving the value of the test statistic (or coefficient) for the corresponding variable (or variable pair).}
        \item{p.values}{A vector (when \code{type = 1}) or matrix (when \code{type = 2}) giving the value of the p-value for the test applied to the corresponding variable (or variable pair).}
        \item{Test}{A vector (when \code{type = 1}) or matrix (when \code{type = 2}) indicating the type of test applied to the corresponding variable (or variable pair).} 
        \item{Breaks}{A list giving the cutpoints used for binning each continuous or semi-continuous variable.}
}
}
\description{
Using a \code{gerbil} object as an input, this function performs univariate and bivariate goodness-of-fit tests
to compare distributions of imputed and observed values.
}
\details{
Goodness of fit is determined using contingency tables of counts across categories of the corresponding variable(s). 
For univariate testing (\code{type = 1}), a one-way table is calculated for observed cases and compared to an analogous table for imputed cases, 
whereas for bivariate testing (\code{type = 2}), two-way tables are calculated.  
Continuous variables are binned according to cut-points defined using the parameter \code{breaks}. 
Tests are performed using one of three methods (determined from the parameter \code{method}): 1) Chi-squared (the default); 2) Fisher's exact; and 3) A G-test. 
G-testing is implemented via the function \code{GTest()} from the \code{DescTools} package.
Note that for univariate testing of continuous variables, a Kolmogorov-Smirnov test may be performed instead by setting \code{ks = TRUE}.

The only required input is a parameter \code{x} which is a \code{gerbil} object.

Note that univariate differences between observed and imputed data may be explained by the missingness mechanism and are not necessarily indicative of poor imputations.
Note also that most imputation methods like gerbil (and mice and related methods) are not designed to capture complete bivariate distributions. As such, the bivariate tests may be likely to return small p-values.
}
\examples{
\donttest{
#Load the India Human Development Survey-II dataset
data(ihd_mcar) 

imps.gerbil <- gerbil(ihd_mcar, m = 1, mcmciter = 200, ords = "education_level", 
       semi = "farm_labour_days", bincat = c("sex", "marital_status", "job_field", "own_livestock"))

#Run univariate tests
tests.gerbil.uni <- gof_gerbil(imps.gerbil, imp = 1, type = 1)

#Print a summary
tests.gerbil.uni

#Run bivariate tests
tests.gerbil.bi <- gof_gerbil(imps.gerbil, imp = 1, type = 2)

#Print a summary
tests.gerbil.bi
}
      
}
