% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GSDimension.R
\docType{class}
\name{GSDimension}
\alias{GSDimension}
\title{A GeoServer dimension}
\format{
\code{\link{R6Class}} object.
}
\value{
Object of \code{\link{R6Class}} for modelling a GeoServer dimension
}
\description{
This class models a GeoServer resource dimension.
}
\details{
Geoserver REST API Dimension
}
\examples{
  dim <- GSDimension$new()

}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{api}
\keyword{dimension}
\keyword{geoserver}
\keyword{resource}
\keyword{rest}
\section{Super class}{
\code{\link[geosapi:GSRESTResource]{geosapi::GSRESTResource}} -> \code{GSDimension}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{enabled}}{true/false}

\item{\code{presentation}}{dimension presentation}

\item{\code{resolution}}{dimension resolution}

\item{\code{units}}{dimension units}

\item{\code{unitSymbol}}{dimension unitsSymbol}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{GSDimension$new()}}
\item \href{#method-decode}{\code{GSDimension$decode()}}
\item \href{#method-setEnabled}{\code{GSDimension$setEnabled()}}
\item \href{#method-setPresentation}{\code{GSDimension$setPresentation()}}
\item \href{#method-setUnit}{\code{GSDimension$setUnit()}}
\item \href{#method-setUnitSymbol}{\code{GSDimension$setUnitSymbol()}}
\item \href{#method-clone}{\code{GSDimension$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="geosapi" data-topic="GSRESTResource" data-id="encode">}\href{../../geosapi/html/GSRESTResource.html#method-encode}{\code{geosapi::GSRESTResource$encode()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Initializes an object of class \link{GSDimension}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSDimension$new(xml = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{xml}}{object of class \link{XMLInternalNode-class}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-decode"></a>}}
\if{latex}{\out{\hypertarget{method-decode}{}}}
\subsection{Method \code{decode()}}{
Decodes from XML
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSDimension$decode(xml)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{xml}}{object of class \link{XMLInternalNode-class}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-setEnabled"></a>}}
\if{latex}{\out{\hypertarget{method-setEnabled}{}}}
\subsection{Method \code{setEnabled()}}{
Set enabled
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSDimension$setEnabled(enabled)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{enabled}}{enabled}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-setPresentation"></a>}}
\if{latex}{\out{\hypertarget{method-setPresentation}{}}}
\subsection{Method \code{setPresentation()}}{
Set presentation
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSDimension$setPresentation(presentation, interval = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{presentation}}{presentation. Possible values: "LIST", "CONTINUOUS_INTERVAL", "DISCRETE_INTERVAL"}

\item{\code{interval}}{interval}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-setUnit"></a>}}
\if{latex}{\out{\hypertarget{method-setUnit}{}}}
\subsection{Method \code{setUnit()}}{
Set unit
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSDimension$setUnit(unit)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{unit}}{unit}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-setUnitSymbol"></a>}}
\if{latex}{\out{\hypertarget{method-setUnitSymbol}{}}}
\subsection{Method \code{setUnitSymbol()}}{
Set unit symbol
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSDimension$setUnitSymbol(unitSymbol)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{unitSymbol}}{unit symbol}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSDimension$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
