% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geos-polygonize.R
\name{geos_polygonize}
\alias{geos_polygonize}
\alias{geos_polygonize_valid}
\alias{geos_polygonize_cut_edges}
\alias{geos_polygonize_full}
\title{Create polygons from noded edges}
\usage{
geos_polygonize(collection)

geos_polygonize_valid(collection)

geos_polygonize_cut_edges(collection)

geos_polygonize_full(collection)
}
\arguments{
\item{collection}{A GEOMETRYCOLLECTION or MULTILINESTRING of
edges that meet at their endpoints.}
}
\value{
A GEOMETRYCOLLECTION of polygons
}
\description{
Create polygons from noded edges
}
\examples{
geos_polygonize("MULTILINESTRING ((0 0, 0 1), (0 1, 1 0), (1 0, 0 0))")
geos_polygonize_valid("MULTILINESTRING ((0 0, 0 1), (0 1, 1 0), (1 0, 0 0))")
geos_polygonize_cut_edges("MULTILINESTRING ((0 0, 0 1), (0 1, 1 0), (1 0, 0 0))")

}
