% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitting.R
\name{intensity_kernel}
\alias{intensity_kernel}
\title{Intensity Estimation on Geometric Networks based on Kernel Smoothing}
\usage{
intensity_kernel(X, kernel = "heat")
}
\arguments{
\item{X}{A point pattern on a geometric network (object of class
\code{gnpp}).}

\item{kernel}{If \code{kernel = "heat"}, a heat kernel is used. If
\code{kernel = "Euclidean"}, a two-dimensional kernel smoother is used.}
}
\value{
A fitted point process on a linear network, an object of class
\code{lppfit}.
}
\description{
Intensity Estimation on Geometric Networks based on Kernel Smoothing
}
\examples{
X <- runifgn(n = 50, G = small_gn)
fit <- intensity_kernel(X)
plot(fit)
}
