% Generated by roxygen2 (4.0.1): do not edit by hand
\name{readmulti.nts}
\alias{readmulti.nts}
\title{Read landmark data from multiple nts files}
\usage{
readmulti.nts(filelist)
}
\arguments{
\item{filelist}{A list of names for the *.nts files to be read by the function. The names in the list
require quotes (") and .nts/.NTS suffix.}
}
\value{
Function returns a (p x k x n) array, where p is the number of landmark points, k is
  the number of landmark dimensions (2 or 3), and n is the number of specimens. The third dimension
  of this array contains names for each specimen, which are obtained from the original file names.
}
\description{
Read a list of names for several *.nts files to obtain landmark coordinates for a set of specimens
}
\details{
This function reads a list containing the names of multiple *.nts files, where each contains the
  landmark coordinates for a single specimen. For these files, the number of variables (columns) of
  the data matrix will equal the number of dimensions of the landmark data (k=2 or 3). When the function
  is called a dialog box is opened, from which the user may select multiple *.nts files. These are then read
  and concatenated into a single matrix for all specimens. The parameter line contains 5 or 6 elements,
  and must begin with a "1" to designate a rectangular matrix. The second and third values designate how
  many specimens (n) and how many total variables (p x k) are in the data matrix.
  The fourth value is a "0" if the data matrix is complete and a "1"
  if there are missing values. If missing values are present, the '1' is followed by the arbitrary
  numeric code used to represent missing values (e.g., -999). These values will be replaced with "NA"
  in the output array. Subsequent analyses requires a full complement of data, see \code{\link{estimate.missing}}.

Missing data may be present in the file by designating them using 'NA'. In
  this case, the standard NTSYS header is used with no numeric designation for missing data (i.e. the fourth value is '0').
  The positions of missing landmarks may then be estimated using estimate.missing.
}
\author{
Dean Adams & Emma Sherratt
}
\keyword{IO}

