% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ISOImagerySensor.R
\docType{class}
\name{ISOImagerySensor}
\alias{ISOImagerySensor}
\title{ISOImagerySensor}
\format{
\code{\link[R6]{R6Class}} object.
}
\value{
Object of \code{\link[R6]{R6Class}} for modelling an ISO imagery sensor
}
\description{
ISOImagerySensor

ISOImagerySensor
}
\references{
- 19115-3 \url{https://schemas.isotc211.org/19115/-3/mac/2.0/mac/#element_MI_Sensor}
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{ISO}
\keyword{imagery}
\keyword{sensor}
\section{Super classes}{
\code{\link[geometa:geometaLogger]{geometa::geometaLogger}} -> \code{\link[geometa:ISOAbstractObject]{geometa::ISOAbstractObject}} -> \code{\link[geometa:ISOImageryInstrument]{geometa::ISOImageryInstrument}} -> \code{ISOImagerySensor}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{hosted}}{hosted [0..*] : ISOImageryInstrument}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ISOImagerySensor-new}{\code{ISOImagerySensor$new()}}
\item \href{#method-ISOImagerySensor-addInstrument}{\code{ISOImagerySensor$addInstrument()}}
\item \href{#method-ISOImagerySensor-delInstrument}{\code{ISOImagerySensor$delInstrument()}}
\item \href{#method-ISOImagerySensor-clone}{\code{ISOImagerySensor$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="geometa" data-topic="geometaLogger" data-id="ERROR"><a href='../../geometa/html/geometaLogger.html#method-geometaLogger-ERROR'><code>geometa::geometaLogger$ERROR()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="geometaLogger" data-id="INFO"><a href='../../geometa/html/geometaLogger.html#method-geometaLogger-INFO'><code>geometa::geometaLogger$INFO()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="geometaLogger" data-id="WARN"><a href='../../geometa/html/geometaLogger.html#method-geometaLogger-WARN'><code>geometa::geometaLogger$WARN()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="addFieldAttrs"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-addFieldAttrs'><code>geometa::ISOAbstractObject$addFieldAttrs()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="addListElement"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-addListElement'><code>geometa::ISOAbstractObject$addListElement()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="checkMetadataStandardCompliance"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-checkMetadataStandardCompliance'><code>geometa::ISOAbstractObject$checkMetadataStandardCompliance()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="contains"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-contains'><code>geometa::ISOAbstractObject$contains()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="createLocalisedProperty"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-createLocalisedProperty'><code>geometa::ISOAbstractObject$createLocalisedProperty()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="decode"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-decode'><code>geometa::ISOAbstractObject$decode()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="delListElement"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-delListElement'><code>geometa::ISOAbstractObject$delListElement()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="encode"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-encode'><code>geometa::ISOAbstractObject$encode()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="getClass"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-getClass'><code>geometa::ISOAbstractObject$getClass()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="getClassName"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-getClassName'><code>geometa::ISOAbstractObject$getClassName()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="getNamespaceDefinition"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-getNamespaceDefinition'><code>geometa::ISOAbstractObject$getNamespaceDefinition()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="isDocument"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-isDocument'><code>geometa::ISOAbstractObject$isDocument()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="isFieldInheritedFrom"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-isFieldInheritedFrom'><code>geometa::ISOAbstractObject$isFieldInheritedFrom()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="print"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-print'><code>geometa::ISOAbstractObject$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="save"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-save'><code>geometa::ISOAbstractObject$save()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setAttr"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setAttr'><code>geometa::ISOAbstractObject$setAttr()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setCodeList"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setCodeList'><code>geometa::ISOAbstractObject$setCodeList()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setCodeListValue"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setCodeListValue'><code>geometa::ISOAbstractObject$setCodeListValue()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setCodeSpace"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setCodeSpace'><code>geometa::ISOAbstractObject$setCodeSpace()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setHref"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setHref'><code>geometa::ISOAbstractObject$setHref()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setId"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setId'><code>geometa::ISOAbstractObject$setId()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setIsNull"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setIsNull'><code>geometa::ISOAbstractObject$setIsNull()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setValue"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setValue'><code>geometa::ISOAbstractObject$setValue()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="stopIfMetadataStandardIsNot"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-stopIfMetadataStandardIsNot'><code>geometa::ISOAbstractObject$stopIfMetadataStandardIsNot()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="validate"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-validate'><code>geometa::ISOAbstractObject$validate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="wrapBaseElement"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-wrapBaseElement'><code>geometa::ISOAbstractObject$wrapBaseElement()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOImageryInstrument" data-id="addCitation"><a href='../../geometa/html/ISOImageryInstrument.html#method-ISOImageryInstrument-addCitation'><code>geometa::ISOImageryInstrument$addCitation()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOImageryInstrument" data-id="addInstrumentationEventList"><a href='../../geometa/html/ISOImageryInstrument.html#method-ISOImageryInstrument-addInstrumentationEventList'><code>geometa::ISOImageryInstrument$addInstrumentationEventList()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOImageryInstrument" data-id="addPlatform"><a href='../../geometa/html/ISOImageryInstrument.html#method-ISOImageryInstrument-addPlatform'><code>geometa::ISOImageryInstrument$addPlatform()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOImageryInstrument" data-id="addSensor"><a href='../../geometa/html/ISOImageryInstrument.html#method-ISOImageryInstrument-addSensor'><code>geometa::ISOImageryInstrument$addSensor()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOImageryInstrument" data-id="delCitation"><a href='../../geometa/html/ISOImageryInstrument.html#method-ISOImageryInstrument-delCitation'><code>geometa::ISOImageryInstrument$delCitation()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOImageryInstrument" data-id="delInstrumentationEventList"><a href='../../geometa/html/ISOImageryInstrument.html#method-ISOImageryInstrument-delInstrumentationEventList'><code>geometa::ISOImageryInstrument$delInstrumentationEventList()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOImageryInstrument" data-id="delPlatform"><a href='../../geometa/html/ISOImageryInstrument.html#method-ISOImageryInstrument-delPlatform'><code>geometa::ISOImageryInstrument$delPlatform()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOImageryInstrument" data-id="delSensor"><a href='../../geometa/html/ISOImageryInstrument.html#method-ISOImageryInstrument-delSensor'><code>geometa::ISOImageryInstrument$delSensor()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOImageryInstrument" data-id="setDescription"><a href='../../geometa/html/ISOImageryInstrument.html#method-ISOImageryInstrument-setDescription'><code>geometa::ISOImageryInstrument$setDescription()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOImageryInstrument" data-id="setIdentifier"><a href='../../geometa/html/ISOImageryInstrument.html#method-ISOImageryInstrument-setIdentifier'><code>geometa::ISOImageryInstrument$setIdentifier()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOImageryInstrument" data-id="setOtherProperty"><a href='../../geometa/html/ISOImageryInstrument.html#method-ISOImageryInstrument-setOtherProperty'><code>geometa::ISOImageryInstrument$setOtherProperty()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOImageryInstrument" data-id="setOtherPropertyType"><a href='../../geometa/html/ISOImageryInstrument.html#method-ISOImageryInstrument-setOtherPropertyType'><code>geometa::ISOImageryInstrument$setOtherPropertyType()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOImageryInstrument" data-id="setType"><a href='../../geometa/html/ISOImageryInstrument.html#method-ISOImageryInstrument-setType'><code>geometa::ISOImageryInstrument$setType()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOImagerySensor-new"></a>}}
\if{latex}{\out{\hypertarget{method-ISOImagerySensor-new}{}}}
\subsection{Method \code{new()}}{
Initializes object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOImagerySensor$new(xml = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{xml}}{object of class \link[XML]{XMLInternalNode-class}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOImagerySensor-addInstrument"></a>}}
\if{latex}{\out{\hypertarget{method-ISOImagerySensor-addInstrument}{}}}
\subsection{Method \code{addInstrument()}}{
Adds instrument
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOImagerySensor$addInstrument(instrument)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{instrument}}{object of class \link{ISOImageryInstrument}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOImagerySensor-delInstrument"></a>}}
\if{latex}{\out{\hypertarget{method-ISOImagerySensor-delInstrument}{}}}
\subsection{Method \code{delInstrument()}}{
Deletes instrument
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOImagerySensor$delInstrument(instrument)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{instrument}}{object of class \link{ISOImageryInstrument}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOImagerySensor-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ISOImagerySensor-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOImagerySensor$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
