% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ISOCoverageDescription.R
\docType{class}
\name{ISOCoverageDescription}
\alias{ISOCoverageDescription}
\title{ISOCoverageDescription}
\format{\code{\link{R6Class}} object.}
\usage{
ISOCoverageDescription
}
\value{
Object of \code{\link{R6Class}} for modelling an ISOCoverageDescription
}
\description{
ISOCoverageDescription
}
\section{Fields}{

\describe{
\item{\code{attributeDescription}}{[\code{\link{ISORecordType}}] attribute description}

\item{\code{contentType}}{[\code{\link{character}}] content type}

\item{\code{dimension}}{[\code{\link{ISORangeDimension}}] range dimension(s)}
}}

\section{Methods}{

\describe{
 \item{\code{new(xml)}}{
   This method is used to instantiate an ISOCoverageDescription
 }
 \item{\code{setAttributeDescription}}{
   Sets the attribute description, as object of class \code{ISORecordType} or
   \code{character}
 }
 \item{\code{setContentType(contentType)}}{
   Sets the content Type, as object of class \code{ISOCoverageContentType} or
   any \code{character} value listed in \code{ISOCoverageContentType$values()}
 }
 \item{\code{addDimension(dimension)}}{
   Adds a dimension, object of class (or subclass of) \code{ISORangeDimension}
 }
 \item{\code{delDimension(dimension)}}{
   Deletes a dimension, object of class (or subclass of) \code{ISORangeDimension}
 }
}
}

\examples{
   #create coverage description
   md <- ISOCoverageDescription$new()
   md$setAttributeDescription("test")
   md$setContentType("modelResult")
   
   #adding 3 arbitrary dimensions
   for(i in 1:3){
      band <- ISOBand$new()
      mn <- ISOMemberName$new(aName = sprintf("name \%s",i), attributeType = sprintf("type \%s",i))
      band$setSequenceIdentifier(mn)
      band$setDescriptor("descriptor")
      band$setMaxValue(10)
      band$setMinValue(1)
      gml <- GMLBaseUnit$new(id = sprintf("ID\%s",i))
      gml$setDescriptionReference("someref")
      gml$setIdentifier("identifier", "codespace")
      gml$addName("name1", "codespace")
      gml$addName("name2", "codespace")
      gml$setQuantityTypeReference("someref")
      gml$setCatalogSymbol("symbol")
      gml$setUnitsSystem("somelink")
      band$setUnits(gml)
      band$setPeakResponse(9)
      band$setBitsPerValue(5)
      band$setToneGradation(100)
      band$setScaleFactor(1)
      band$setOffset(4)
      md$addDimension(band)
   }
   xml <- md$encode()
   
}
\references{
ISO 19115:2003 - Geographic information -- Metadata
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{ISO}
\keyword{coverage}
\keyword{description}
