% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/properties.R
\name{properties}
\alias{properties}
\alias{properties_add}
\alias{properties_get}
\title{Add or get properties}
\usage{
properties_add(x, ..., .list = NULL)

properties_get(x, property)
}
\arguments{
\item{x}{An object of class \code{geojson}}

\item{...}{Properties to be added, supports NSE as well as SE}

\item{.list}{a named list of properties to add. must be named}

\item{property}{(character) property name}
}
\description{
Add or get properties
}
\examples{
# add properties
x <- '{ "type": "LineString", "coordinates": [ [100.0, 0.0], [101.0, 1.0] ]}'
(y <- linestring(x))
y \%>\% feature() \%>\% properties_add(population = 1000)

## add with a named list already created
x <- '{ "type": "LineString", "coordinates": [ [100.0, 0.0], [101.0, 1.0] ]}'
(y <- linestring(x))
props <- list(population = 1000, temperature = 89, size = 5)
y \%>\% feature() \%>\% properties_add(.list = props)

## combination of NSE and .list
x <- '{ "type": "LineString", "coordinates": [ [100.0, 0.0], [101.0, 1.0] ]}'
(y <- linestring(x))
props <- list(population = 1000, temperature = 89, size = 5)
y \%>\% feature() \%>\% properties_add(stuff = 4, .list = props)

# features to featurecollection
x <- '{ "type": "Point", "coordinates": [100.0, 0.0] }'
point(x) \%>\%
  feature() \%>\%
  featurecollection() \%>\%
  properties_add(population = 10)

# get property
x <- '{ "type": "LineString", "coordinates": [ [100.0, 0.0], [101.0, 1.0] ]}'
(y <- linestring(x))
x <- y \%>\% feature() \%>\% properties_add(population = 1000)
properties_get(x, property = 'population')
}
\references{
\url{http://geojson.org/geojson-spec.html}
}
