% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crs.R
\name{crs}
\alias{crs}
\alias{crs_add}
\alias{crs_get}
\title{Add or get CRS}
\usage{
crs_add(x, crs)

crs_get(x)
}
\arguments{
\item{x}{An object of class \code{geojson}}

\item{crs}{(character) a CRS string. required.}
}
\description{
Add or get CRS
}
\details{
According to RFC 7946
(\url{https://tools.ietf.org/html/rfc7946#page-12}) the CRS for all GeoJSON
objects must be WGS-84, equivalent to \code{urn:ogc:def:crs:OGC::CRS84}.
And lat/long must be in decimal degrees.

Given the above, but considering that GeoJSON blobs exist that have CRS
attributes in them, we provide CRS helpers here. But moving forward
these are not likely to be used much.
}
\examples{
x <- '{ "type": "Polygon",
"coordinates": [
  [ [100.0, 0.0], [101.0, 0.0], [101.0, 1.0], [100.0, 1.0], [100.0, 0.0] ]
  ]
}'

# add crs
crs <- '{"type": "name",
 "properties": {
     "name": "urn:ogc:def:crs:OGC:1.3:CRS84"
}}'
x \%>\% feature() \%>\% crs_add(crs)

# get crs
z <- x \%>\% feature() \%>\% crs_add(crs)
crs_get(z)
}
\references{
\url{https://github.com/OSGeo/proj.4},
\url{http://geojson.org/geojson-spec.html#coordinate-reference-system-objects}
}

