% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polarstereo.R
\name{polarstereo_fwd}
\alias{polarstereo_fwd}
\alias{polarstereo_rev}
\title{Polar Stereographic projection}
\usage{
polarstereo_fwd(x, northp, k0 = 0.994)

polarstereo_rev(x, y, northp, k0 = 0.994)
}
\arguments{
\item{x}{For forward conversion: a two-column matrix or data frame of
coordinates (longitude, latitude) in decimal degrees.
For reverse conversion: numeric vector of x (easting) coordinates in meters.}

\item{northp}{Logical indicating hemisphere: TRUE for north polar, FALSE for
south polar. Can be a vector for different hemispheres per point.}

\item{k0}{Scale factor at the pole. Default is 0.994 (UPS standard).
Use k0 = 1 for true stereographic.}

\item{y}{Numeric vector of y (northing) coordinates in meters (reverse only).}
}
\value{
Data frame with columns:
\itemize{
\item For forward conversion:
\itemize{
\item \code{x}: Easting in meters from pole
\item \code{y}: Northing in meters from pole
\item \code{convergence}: Grid convergence in degrees
\item \code{scale}: Scale factor at the point
\item \code{lon}, \code{lat}: Input coordinates (echoed)
\item \code{northp}: Hemisphere indicator (echoed)
}
\item For reverse conversion:
\itemize{
\item \code{lon}: Longitude in decimal degrees
\item \code{lat}: Latitude in decimal degrees
\item \code{convergence}: Grid convergence in degrees
\item \code{scale}: Scale factor at the point
\item \code{x}, \code{y}: Input coordinates (echoed)
\item \code{northp}: Hemisphere indicator (echoed)
}
}
}
\description{
Convert geographic coordinates to/from Polar Stereographic projection.
This conformal projection is used for polar regions and is the basis
for the Universal Polar Stereographic (UPS) system.
}
\details{
The Polar Stereographic projection is a conformal azimuthal projection
centered on either pole. It is ideal for mapping polar regions because:
\itemize{
\item It preserves local angles and shapes
\item Directions from the pole are true
\item Scale distortion is minimal near the pole
}

\strong{UPS (Universal Polar Stereographic)}
The default k0 = 0.994 corresponds to the UPS system used by:
\itemize{
\item NATO military mapping
\item EPSG:32661 (UPS North) and EPSG:32761 (UPS South)
\item High-latitude extensions of UTM
}

UPS is used for latitudes poleward of 84°N and 80°S.

\strong{Common scale factors:}
\itemize{
\item k0 = 0.994: UPS standard
\item k0 = 1.0: True stereographic (scale = 1 at pole)
\item k0 = 0.97276901289: NSIDC Sea Ice Polar Stereographic
}
}
\examples{
# Antarctic stations
stations <- cbind(
  lon = c(166.67, 77.97, -43.53, 0),
  lat = c(-77.85, -67.60, -60.72, -90)
)
polarstereo_fwd(stations, northp = FALSE)

# Arctic points
arctic <- cbind(lon = c(0, 90, 180, -90), lat = c(85, 85, 85, 85))
polarstereo_fwd(arctic, northp = TRUE)

# True stereographic (k0 = 1)
polarstereo_fwd(stations, northp = FALSE, k0 = 1.0)

# NSIDC Sea Ice projection
polarstereo_fwd(stations, northp = FALSE, k0 = 0.97276901289)

# South Pole is at origin
sp <- polarstereo_fwd(c(0, -90), northp = FALSE)
sp$x  # 0
sp$y  # 0

# Round-trip conversion
fwd <- polarstereo_fwd(stations, northp = FALSE)
polarstereo_rev(fwd$x, fwd$y, northp = FALSE)
}
\seealso{
\code{\link[=utmups_fwd]{utmups_fwd()}} for automatic UTM/UPS selection based on latitude.
}
