% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uscb_folder_get_layer.R
\name{get_common_flat_table}
\alias{get_common_flat_table}
\alias{get_common_flat_table.uscb_folder}
\title{Get common flat table}
\usage{
get_common_flat_table(uf, remove_zeros = TRUE, remove_geometry = FALSE)

\method{get_common_flat_table}{uscb_folder}(uf, remove_zeros = TRUE, remove_geometry = TRUE)
}
\arguments{
\item{uf}{A \code{uscb_folder} object.}

\item{remove_zeros}{A boolean, remove data with zero value.}

\item{remove_geometry}{A boolean, remove geometry column.}
}
\value{
A \code{tibble} object.
}
\description{
Get the layer group data in the form of a flat table that includes all the
available data columns for the geodatabases corresponding to the selected
years.
}
\details{
Optionally you can delete the rows whose measurement value is zero and remove
the geometry column.
}
\examples{

folder <- system.file("extdata", package = "geogenr")
folder <- stringr::str_replace_all(paste(folder, "/", ""), " ", "")
ua <- uscb_acs_5ye(folder = folder)
sa <- ua |> get_statistical_areas()
# sa[6]
# [1] "New England City and Town Area Division"
ul <- uscb_layer(uscb_acs_metadata, ua = ua, geodatabase = sa[6], year = 2015)
layers <- ul |> get_layer_names()
# layers[3]
# [1] "X02_RACE"
ul <- ul |> get_layer(layers[3])
lg <- ul |> get_layer_group_names()
# lg[2]
# [1] "003 - DETAILED RACE"
ul <- ul |> get_layer_group(lg[2])
uf <- uscb_folder(ul)

layer_common <- uf |> get_common_flat_table()

}
\seealso{
Other result generation functions: 
\code{\link{get_common_geomultistar}()},
\code{\link{get_flat_table}()},
\code{\link{get_geomultistar}()}
}
\concept{result generation functions}
