\name{land use}

\alias{cropland_africa}

\title{Land use data}

\description{
Download cropland extent data for Africa. 

The data are probabilities of cropland presence estimated with a neural network that was trained on an initial 1-million point Geosurvey (https://geosurvey.qed.ai) conducted in 2015. 

These data were generated by the Africa Soil Information Service (AfSIS) project. 

License: CC-BY-SA 4.0
}

\usage{
cropland_africa(path, ...) 
}

\arguments{
  \item{path}{character. Path name where the data should be downloaded to} 
  \item{...}{additional arguments passed to \code{\link{download.file}}}  
}

\value{
SpatRaster
}

\seealso{
\url{https://about.maps.qed.ai/}
}

\examples{
\donttest{
cropland <- cropland_africa(path=tempdir())
}
}
