% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/side_functions.R
\name{select_parameters}
\alias{select_parameters}
\alias{selectParameters}
\title{Select parameters for a clustering algorithm}
\usage{
select_parameters(
  algo,
  data,
  k,
  m,
  alpha = NA,
  beta = NA,
  nblistw = NULL,
  lag_method = "mean",
  window = NULL,
  spconsist = TRUE,
  classidx = TRUE,
  nrep = 30,
  indices = NULL,
  standardize = TRUE,
  robust = FALSE,
  noise_cluster = FALSE,
  delta = NA,
  maxiter = 500,
  tol = 0.01,
  seed = NULL,
  init = "random",
  verbose = TRUE
)

selectParameters(
  algo,
  data,
  k,
  m,
  alpha = NA,
  beta = NA,
  nblistw = NULL,
  lag_method = "mean",
  window = NULL,
  spconsist = TRUE,
  classidx = TRUE,
  nrep = 30,
  indices = NULL,
  standardize = TRUE,
  robust = FALSE,
  noise_cluster = FALSE,
  delta = NA,
  maxiter = 500,
  tol = 0.01,
  seed = NULL,
  init = "random",
  verbose = TRUE
)
}
\arguments{
\item{algo}{A string indicating which method to use (FCM, GFCM, SFCM, SGFCM)}

\item{data}{A dataframe with numeric columns or a list of rasters.}

\item{k}{A sequence of values for k to test (>=2)}

\item{m}{A sequence of values for m to test}

\item{alpha}{A sequence of values for alpha to test (NULL if not required)}

\item{beta}{A sequence of values for beta to test (NULL if not required)}

\item{nblistw}{A list of list.w objects describing the neighbours typically
produced by the spdep package (NULL if not required)}

\item{lag_method}{A string indicating if a classical lag must be used
("mean") or if a weighted median must be used ("median"). Both can be
tested by specifying a vector : c("mean","median"). When working with rasters,
the string must be parsable to a function like mean, min, max, sum, etc. and will
be applied to all the pixels values in the window designated by the parameter window
and weighted according to the values of this matrix.}

\item{window}{A list of windows to use to calculate neighbouring values if
rasters are used.}

\item{spconsist}{A boolean indicating if the spatial consistency must be
calculated}

\item{classidx}{A boolean indicating if the quality of classification
indices must be calculated}

\item{nrep}{An integer indicating the number of permutation to do to simulate
the random distribution of the spatial inconsistency. Only used if spconsist
is TRUE.}

\item{indices}{A character vector with the names of the indices to calculate, to
evaluate clustering quality. default is :c("Silhouette.index", "Partition.entropy",
"Partition.coeff", "XieBeni.index", "FukuyamaSugeno.index", "Explained.inertia").
Other available indices are : "DaviesBoulin.index", "CalinskiHarabasz.index",
"GD43.index", "GD53.index" and "Negentropy.index".}

\item{standardize}{A boolean to specify if the variable must be centered and
reduce (default = True)}

\item{robust}{A boolean indicating if the "robust" version of the algorithm must be used (see details)}

\item{noise_cluster}{A boolean indicatong if a noise cluster must be added to the solution (see details)}

\item{delta}{A float giving the distance of the noise cluster to each observation}

\item{maxiter}{An integer for the maximum number of iteration}

\item{tol}{The tolerance criterion used in the evaluateMatrices function for
convergence assessment}

\item{seed}{An integer used for random number generation. It ensures that the
start centers will be the same if the same integer is selected.}

\item{init}{A string indicating how the initial centers must be selected. "random"
indicates that random observations are used as centers. "kpp" use a distance based method
resulting in more dispersed centers at the beginning. Both of them are heuristic.}

\item{verbose}{A boolean indicating if a progressbar should be displayed}
}
\value{
A dataframe with indicators assessing the quality of classifications
}
\description{
Function to select the parameters for a clustering algorithm.
}
\examples{
\donttest{
data(LyonIris)
AnalysisFields <-c("Lden","NO2","PM25","VegHautPrt","Pct0_14","Pct_65","Pct_Img",
"TxChom1564","Pct_brevet","NivVieMed")
dataset <- sf::st_drop_geometry(LyonIris[AnalysisFields])
queen <- spdep::poly2nb(LyonIris,queen=TRUE)
Wqueen <- spdep::nb2listw(queen,style="W")
#set spconsist to TRUE to calculate the spatial consistency indicator
#FALSE here to reduce the time during package check
values <- select_parameters(algo = "SFCM", dataset, k = 5, m = seq(2,3,0.1),
    alpha = seq(0,2,0.1), nblistw = Wqueen, spconsist=FALSE)
}
\donttest{
data(LyonIris)
AnalysisFields <-c("Lden","NO2","PM25","VegHautPrt","Pct0_14","Pct_65","Pct_Img",
"TxChom1564","Pct_brevet","NivVieMed")
dataset <- sf::st_drop_geometry(LyonIris[AnalysisFields])
queen <- spdep::poly2nb(LyonIris,queen=TRUE)
Wqueen <- spdep::nb2listw(queen,style="W")
#set spconsist to TRUE to calculate the spatial consistency indicator
#FALSE here to reduce the time during package check
values <- selectParameters(algo = "SFCM", dataset, k = 5, m = seq(2,3,0.1),
    alpha = seq(0,2,0.1), nblistw = Wqueen, spconsist=FALSE)
}
}
