% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FCMclass.R
\name{plot.FCMres}
\alias{plot.FCMres}
\title{Plot method for FCMres object}
\usage{
\method{plot}{FCMres}(x, type = "spider", ...)
}
\arguments{
\item{x}{A FCMres object, typically obtained from functions CMeans,
GCMeans, SFCMeans, SGFCMeans. Can also be a simple membership matrix.}

\item{type}{A string indicating the type of plot to show. Can be one of
"bar", "violin", or "spider". Default is spider.}

\item{...}{not used}
}
\value{
a ggplot2 object, a list, or NULL, depending on the type of plot requested
}
\description{
Method to plot the results of a FCM.res object
}
\details{
This S3 method is a simple dispatcher for the functions barPlots,
violinPlots and spiderPlots. To be able to use all their specific
parameters, one can use them directly.
}
\examples{
data(LyonIris)
AnalysisFields <-c("Lden","NO2","PM25","VegHautPrt","Pct0_14","Pct_65","Pct_Img",
"TxChom1564","Pct_brevet","NivVieMed")

# rescaling all the variables used in the analysis
for (field in AnalysisFields) {
    LyonIris[[field]] <- scale(LyonIris[[field]])
}

# doing the initial clustering
dataset <- sf::st_drop_geometry(LyonIris[AnalysisFields])
queen <- spdep::poly2nb(LyonIris,queen=TRUE)
Wqueen <- spdep::nb2listw(queen,style="W")
result <- SGFCMeans(dataset, Wqueen,k = 5, m = 1.5, alpha = 1.5, beta = 0.5, standardize = FALSE)

plot(result, type = "spider")
}
