% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatial_matrices.R
\name{circular_window}
\alias{circular_window}
\title{Circular window}
\usage{
circular_window(radius, res)
}
\arguments{
\item{radius}{The size in metres of the radius of the circular focal}

\item{res}{The width in metres of a pixel. It is assumed that pixels are squares.}
}
\value{
A binary weight matrix
}
\description{
Create a matrix that can be used as a window when working with
rasters. It uses a radius to set to 0 the weights of pixels that are farther
than this distance. This is helpful to create circular focals.
}
\details{
The original function comes from here: https://scrogster.wordpress.com/2012/10/05/applying-a-circular-moving-window-filter-to-raster-data-in-r/
but we reworked it to make it faster and to ensure that the result is a matrix with odd dimensions.
}
\examples{
# wide of 100 metres for pixels of 2 metres
window <- circular_window(100, 2)
# row standardisation
window_row_std <- window / sum(window)
}
