% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_cf_dens.R
\name{sim_cf_dens}
\alias{sim_cf_dens}
\title{Simulate counterfactual densities}
\usage{
sim_cf_dens(
  expected_number,
  base_dens,
  power_sim_results,
  window,
  grayscale = FALSE
)
}
\arguments{
\item{expected_number}{the expected number of observations}

\item{base_dens}{the baseline density (im object)}

\item{power_sim_results}{the results obtained by `simulate_power_density()`}

\item{window}{owin object}

\item{grayscale}{logical. `grayscale` specifies whether to convert plot to grayscale (by default, FALSE).}
}
\value{
list of counterfactual densities, a ggplot, and priorities
}
\description{
`sim_cf_dens()` takes a list of power densities
and returns simulated counterfactual densities.
}
\examples{
# Baseline density
baseline <- get_base_dens(data = airstrikes_base, 
                          coordinates = c("longitude", "latitude"),
                          window = iraq_window,
                          grayscale = FALSE)
                          
# Density 1: Distance from Mosul
dist_from_mosul <- get_dist_focus(window = iraq_window,
                                  longitude = c(43.158),
                                  latitude = c(36.349),
                                  resolution = 0.5,
                                  grayscale = FALSE,
                                  mile = FALSE,
                                  preprocess = FALSE)

# Density 2: Distance from Baghdad
dist_from_baghd <- get_dist_focus(window = iraq_window,
                                  longitude = c(44.366),
                                  latitude = c(33.315),
                                  resolution = 0.5,
                                  grayscale = FALSE,
                                  mile = FALSE,
                                  preprocess = FALSE)
                                  
# Simulation of power density
sim_power_mosul <- sim_power_dens(target_dens = list(dist_from_baghd$distance_im),
                                  dens_manip = dist_from_mosul$distance_im,
                                  priorities = 1,
                                  priorities_manip = c(1, 2, 5, 10, 15, 50),
                                  window = iraq_window,
                                  grayscale = FALSE)

# Simulation of counterfactual density
sim_cf_dens(expected_number = 3,
            base_dens = baseline$density,
            power_sim_results = sim_power_mosul,
            window = iraq_window,
            grayscale = FALSE)
}
