% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_indigenous_land.R
\name{read_indigenous_land}
\alias{read_indigenous_land}
\title{Download spatial data of indigenous lands in Brazil}
\usage{
read_indigenous_land(date = 201907, simplified = TRUE, showProgress = TRUE)
}
\arguments{
\item{date}{A date number in YYYYMM format. Defaults to \code{201907}}

\item{simplified}{Logic \code{FALSE} or \code{TRUE}, indicating whether the function
returns the data set with original' resolution or a data set with 'simplified'
borders. Defaults to \code{TRUE}. For spatial analysis and statistics users should
set \code{simplified = FALSE}. Borders have been simplified by removing vertices of
borders using \code{sf::st_simplify()} preserving topology with a \code{dTolerance} of 100.}

\item{showProgress}{Logical. Defaults to \code{TRUE} display progress bar}
}
\value{
An \verb{"sf" "data.frame"} object
}
\description{
The data set covers the whole of Brazil and it includes indigenous lands from
all ethnicities and in different stages of demarcation. The original data
comes from the National Indian Foundation (FUNAI) and can be found at
\url{http://www.funai.gov.br/index.php/shape}. Although original data is
updated monthly, the geobr package will only keep the data for a few months
per year.
}
\examples{
\dontrun{ if (interactive()) {
# Read all indigenous land in an specific date
i <- read_indigenous_land(date=201907)
}}
}
