% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Spectra-Methods.R
\name{spc.export.xlsx}
\alias{spc.export.xlsx}
\alias{spc.export.xlsx,Spectra-method}
\title{Exports a \code{Spectra} object into Excel format.}
\usage{
spc.export.xlsx(
  input,
  filename,
  sheetName,
  writeheader = TRUE,
  append = F,
  sep = ";",
  ...
)

\S4method{spc.export.xlsx}{Spectra}(
  input,
  filename,
  sheetName,
  writeheader = TRUE,
  append = F,
  sep = ";",
  ...
)
}
\arguments{
\item{input}{A \code{Spectra} object}

\item{filename}{Name of the output xlsx file}

\item{sheetName}{The \code{Spectra} object to be output.}

\item{writeheader}{A boolean, indicating whether or not the metadata (contents of the 
slot \code{header}) is to be included in the excel file. Default : TRUE}

\item{append}{A boolean, indicating whether or not to append the contents of the \code{Spectra} object
into the existing file. Default : FALSE (overwrites the existing Excel file if it exists.)}

\item{sep}{Not used.}

\item{...}{Not used.}
}
\value{
None. Simply creates an Excel file on disk.
}
\description{
Exports  a \code{Spectra} object into Excel format.
}
\details{
\code{spc.export.xlsx()} calls functions from package \code{xlsx} to write the contents of 
a \code{Spectra} object into an Excel file. For this function to work, make sure the 
package \code{xlsx} is installed.
}
\examples{
\dontrun{
  sp=spc.example_spectra()
  if("xlsx" \%in\% installed.packages())
     spc.export.xlsx(sp,"test.xlsx")
}

}
