% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/revlogreg.R
\name{revlogreg}
\alias{revlogreg}
\title{Reverse logistic regression estimation}
\usage{
revlogreg(lglk, N)
}
\arguments{
\item{lglk}{The value of the loglikelihood at different samples and
different parameters. This should be entered as a matrix where the
rows are the values of the samples and the columns correspond to
the parameters. The
[i,j] element of the matrix is the value of the loglikelihood at
the ith sample when all samples are put together evaluated
at the jth parameter value.}

\item{N}{A vector of length ncol(lglk) or a scalar corresponding to
the sample sizes from each model. Must sum(N) == nrow(lglk). The 
first N[1] samples come from model corresponding to the first set
of parameters, then (N[1]+1):N[2] are from the model corresponding
to the second set of parameters, and so on.}
}
\value{
A vector containing the reverse logistic regression estimates
  of the logarithm of the Bayes factors.
  The first set of parameters is taken as the reference model so its
  estimate is always 0.
}
\description{
Perform the reverse logistic regression estimation
}
\details{
Estimation is done by maximising the reverse logistic log likelihood.
}
