% Generated by roxygen2 (4.0.1.99): do not edit by hand
\name{linkfcn}
\alias{linkfcn}
\alias{linkinv}
\title{Calculate the link function for exponential families}
\usage{
linkfcn(mu, linkp, family = c("gaussian", "binomial", "poisson", "Gamma"))

linkinv(z, linkp, family = c("gaussian", "binomial", "poisson", "Gamma"))
}
\arguments{
\item{mu}{Numeric. The mean of the response variable.}

\item{z}{Numeric. The linear predictor.}

\item{linkp}{The link function parameter. A scalar but for the
binomial family is also allowed to have the character values
"logit" or "probit".}

\item{family}{The distribution of the response variable.}
}
\value{
A numeric array of the same dimension as the function's
first argument.
}
\description{
Link function for the exponential family.
}
\details{
\code{linkfcn} maps the mean of the response variable \code{mu} to
the linear predictor \code{z}. \code{linkinv} is its inverse.

Note that the logit link for the
binomial family is defined as the quantile of the logistic
distribution with scale 0.6458.

For the Gaussian family, if the link parameter is positive, then
the extended link is used, defined by \deqn{z =
\frac{sign(\mu)|\mu|^\nu - 1}{\nu}}{z = (sign(mu)*abs(mu)^nu -
1)/nu} In the other case, the link function is the same as for the
Poisson and gamma families.

For the Poisson and gamma families, the Box-Cox transformation is
used, defined by \deqn{z = \frac{\mu^\nu - 1}{\nu}}{z = (mu^nu -
1)/nu}
}
\examples{
\dontrun{
mu <- seq(0.1, 0.9, 0.1)
linkfcn(mu, 7, "binomial")       # robit(7) link function
linkfcn(mu, "logit", "binomial") # logit link function

mu <- seq(-3, 3, 1)
linkfcn(mu, 0.5, "gaussian")     # sqrt transformation
linkinv(linkfcn(mu, 0.5, "gaussian"), 0.5, "gaussian")
curve(linkfcn(x, 0.5, "gaussian"), -3, 3)
}
}
\seealso{
\code{\link{comparebinlinks}}
}

