% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/variofit.R
\name{variofit}
\alias{variofit}
\title{Function that fits a model to a variogram.}
\usage{
variofit(vagram, model = 1, option = 2, interactivt = F, sill = 0)
}
\arguments{
\item{vagram}{List with the calculated variogram. Components of the list
are: \$dist mean distance of the interval.  <s-example> \$vario calculated
value of the variogram.  \$number number of datapoints in the interval.
</s-example> In nearly all cases vagram will be the output from the program
variogram.}

\item{model}{Type of model.  Default is spherical.  It is currently the only
model supported.}

\item{option}{Method to use in automatic fitting.  Allowed values are 1,2,3
and 4.  Default value is 2.  For further information see below.}

\item{interactivt}{If T the fitting is done interactively by plotting the
variogram on the screen and asking the user to select sill, range and nugget
by the locator function.}

\item{sill}{Sill of the variogram, or: Limit of the variogram tending to
infinity lag distances (wikipedia).}
}
\description{
Function that fits a model to a variogram.  The fitting occurs either
automatically or interactively.  The function is called after the function
variogram which calculates the variogram to which the model is fitted.
Currently only spherical model is supported.  Later other models will be
added.
}
\section{Value}{
 <s-example> A list with the following components.  \$nugget
: Estimated nugget effect \$sill : Estimated sill \$range : Estimated range
\$dist : mean distance of the interval.  \$vario : calculated value of the
variogram.  \$number : number of datapoints in the interval. </s-example>
}
\seealso{
\code{\link{variogram}}, \code{\link{pointkriging}}.
}

