% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/varlist.r
\name{varlist}
\alias{varlist}
\title{creates a formula object from a varlist, mostly for internal use.}
\usage{
varlist(x, type = "formula")
}
\arguments{
\item{x}{the varlist to be converted in "var1 var2 var3" format.  Can be specified using the \emph{globbing} characters "*" (match zero or more of any character) or "?" (match any single character) like "var*" or "var?" for "var1 var2 var3" or using regular expressions if \code{regex=TRUE} ("var[0-9]+" = "var1 var2 var3").}

\item{type}{if "formula", return a varlist in formula format; if "vector", return a varlist in character vector format.}
}
\value{
a formula object which can be passed to \code{model.frame} or a character vector giving the name of each variable
}
\description{
A varlist in \code{genvar} is either a space-separated string with wildcard characters, "var1 var2 var3 x*", or an R formula object ~var1+var2+var3+x1+x2....  This function converts from the more user-friendly space-separated string format to the formula format or to a vector of strings.
}
