% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.gensvm.R
\name{plot.gensvm}
\alias{plot.gensvm}
\title{Plot the simplex space of the fitted GenSVM model}
\usage{
\method{plot}{gensvm}(
  x,
  labels,
  newdata = NULL,
  with.margins = TRUE,
  with.shading = TRUE,
  with.legend = TRUE,
  center.plot = TRUE,
  xlim = NULL,
  ylim = NULL,
  ...
)
}
\arguments{
\item{x}{A fitted \code{gensvm} object}

\item{labels}{the labels to color points with. If this is omitted the 
predicted labels are used.}

\item{newdata}{the dataset to plot. If this is NULL the training data is 
used.}

\item{with.margins}{plot the margins}

\item{with.shading}{show shaded areas for the class regions}

\item{with.legend}{show the legend for the class labels}

\item{center.plot}{ensure that the boundaries and margins are always visible 
in the plot}

\item{xlim}{allows the user to force certain plot limits. If set, these 
bounds will be used for the horizontal axis.}

\item{ylim}{allows the user to force certain plot limits. If set, these 
bounds will be used for the vertical axis and the value of center.plot will 
be ignored}

\item{...}{further arguments are passed to the builtin plot() function}
}
\value{
returns the object passed as input
}
\description{
This function creates a plot of the simplex space for a fitted 
GenSVM model and the given data set. This function works for dataset with 
two or three classes. For more than 3 classes, the simplex space is too high 
dimensional to easily visualize.
}
\examples{
x <- iris[, -5]
y <- iris[, 5]

# train the model
fit <- gensvm(x, y)

# plot the simplex space
plot(fit)

# plot and use the true colors (easier to spot misclassified samples)
plot(fit, y)

# plot only misclassified samples
x.mis <- x[predict(fit) != y, ]
y.mis.true <- y[predict(fit) != y]
plot(fit, newdata=x.mis)
plot(fit, y.mis.true, newdata=x.mis)

# plot a 2-d model
xx <- x[y \%in\% c('versicolor', 'virginica'), ]
yy <- y[y \%in\% c('versicolor', 'virginica')]
fit <- gensvm(xx, yy, kernel='rbf', max.iter=1000)
plot(fit)

}
\references{
Van den Burg, G.J.J. and Groenen, P.J.F. (2016). \emph{GenSVM: A Generalized 
Multiclass Support Vector Machine}, Journal of Machine Learning Research, 
17(225):1--42. URL \url{https://jmlr.org/papers/v17/14-526.html}.
}
\seealso{
\code{\link{plot.gensvm.grid}}, \code{\link{predict.gensvm}}, 
\code{\link{gensvm}}, \code{\link{gensvm-package}}
}
\author{
Gerrit J.J. van den Burg, Patrick J.F. Groenen \cr
Maintainer: Gerrit J.J. van den Burg <gertjanvandenburg@gmail.com>
}
