% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{csibank}
\alias{csibank}
\title{csibank}
\format{
csibank data refers to a 2008 marketing research study of a
leading Spanish firm providing retail financial services. For confidentiality reasons, 
the complete details of the survey-based study will not be provided, only a description 
of the variables. The data include a total of 32 variables, measured for
1707 clients. The 32 variables are divided into two groups: a group 
formed of 27 indicator variables for the structural model, and a group 
formed of 5 categorical variables. Each block of indicators refers to a specific construct.

Latent variable description:
\itemize{
     \item{\code{IMAG}}: Includes variables such as reputation, trustworthiness, seriousness, solidness, and caring about customer's needs \cr
     \item{\code{EXPE}}: Includes variables such as products and services provided, customer service, solution provision, and expectations for overall quality \cr
     \item{\code{QUAL}}: Includes variables such as reliable products and services, range of products and services, personal advice, and overall perceived quality \cr
     \item{\code{VAL}}: Includes variables such as beneficial services and products, valuable investments, quality relative to price, and price relative to quality \cr
     \item{\code{SAT}}: Includes variables such as overall satisfaction rating, fulfillment of expectations, satisfaction relative to other banks, and performance relative to an ideal bank \cr
     \item{\code{LOY}}: Includes variables such as likelihood of choosing the same bank again,  likelihood of switching to another bank, intention to recommend the bank to friends, and feeling of loyalty \cr
}

Manifest variables description:
\itemize{
\item{\code{imag1}: }{Bank's reputation}
\item{\code{imag2}: }{Trustworthiness}
\item{\code{imag3}: }{Bank's solidity}
\item{\code{imag4}: }{Bank's emphasis on public affairs}
\item{\code{imag5}: }{Fifth MV of the block Image}
\item{\code{imag6}: }{Caring about the customer’s needs}
\item{\code{expe1}: }{Providing products and services to meet the customer's needs}
\item{\code{expe2}: }{Providing customer service}
\item{\code{expe3}: }{Providing solutions to daily banking needs}
\item{\code{expe4}: }{Expectations of overall quality}
\item{\code{qual1}: }{Reliable products and services}
\item{\code{qual2}: }{Range of products and services}
\item{\code{qual3}: }{Degree to which customer feels well informed}
\item{\code{qual4}: }{Personal advice}
\item{\code{qual5}: }{Customer service}
\item{\code{qual6}: }{Overall rating of perceived quality}
\item{\code{qual7}: }{Overall rating of satisfaction}
\item{\code{val1}: }{Beneficial services and products}
\item{\code{val2}: }{Valuable investments}
\item{\code{val3}: }{Quality relative to price}
\item{\code{val4}: }{Price relative to quality}
\item{\code{sat1}: }{Overall rating of satisfaction}
\item{\code{sat2}: }{Fulfillment of expectations}
\item{\code{sat3}: }{Rating the performance relative to customer's ideal bank}
\item{\code{loy1}: }{Propensity to choose the same bank if the customer had to choose again}
\item{\code{loy2}: }{Propensity to switch to other banks if they offered better terms}
\item{\code{loy3}: }{Customer's intention to recommend the bank to friends or colleagues}
}

Categorical variables description: 
\itemize{
\item{\code{Gender}: }{Gender of the customers, a factor with levels: \code{Female} and \code{Male}}
\item{\code{Age}: }{Age of the customers, a factor with levels: \code{<=25}, \code{26-35}, \code{36-45}, \code{46-55}, \code{56-65}, and \code{>=66}}
\item{\code{Education}: }{Education of the customers, a factor with levels: \code{Elementary}, \code{Graduated}, \code{Highschool}, \code{Undergrad}, and \code{Unfinished}}
\item{\code{Occupation}: }{Occupation of the customers, a factor with levels: \code{Manager}, \code{MediumEmplo}, \code{Notemploy}, \code{OwnFreelan}, and \code{Retired}}
\item{\code{Region}: }{Region of residence of the customers, a factor with levels: \code{Center}, \code{East}, \code{North}}
}
}
\source{
Laboratory of Information Analysis and Modeling (LIAM). 
   Facultat de Informatica de Barcelona, Universitat Politecnica de Catalunya.
}
\usage{
csibank
}
\description{
csibank
}
\references{
Lamberti, G. et al. (2017). The Pathmox approach for PLS path modeling: discovering 
which constructs differentiate segments.\emph{Applied Stochastic Models in Business and Industry}, 
doi: 10.1002/asmb.2270.

Lamberti, G. (2014) \emph{Modeling with Heterogeneity.} PhD Dissertation.
}
\keyword{datasets}
