% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/artists.R
\name{get_artist_songs}
\alias{get_artist_songs}
\title{Retrieve metadata for all of an artist's songs}
\usage{
get_artist_songs(
  artist_id,
  sort = c("title", "popularity"),
  include_features = FALSE,
  access_token = genius_token()
)
}
\arguments{
\item{artist_id}{ID of the artist (\code{artist_id} within an object returned by
\code{\link{search_artist}})}

\item{sort}{method to order results; by "title" (default) or by
"popularity"}

\item{include_features}{Whether to return results where artist
isn't the primary artist (logical, defaults to FALSE)}

\item{access_token}{Genius' client access token, defaults to \code{genius_token}}
}
\value{
a \code{genius_resource} object that contains the extracted content from the request,
the original JSON response object and the request path.
}
\description{
The Genius API lets you search for song metadata of an artist,
given an artist ID. \code{get_artist_songs} returns this data
in full.
}
\examples{
\dontrun{
get_artist_songs(artist_id = 1421)
get_artist_songs(artist_id = 1421, sort = "popularity")
get_artist_songs(artist_id = 1421, include_features = TRUE)
}
}
\seealso{
See \code{\link{get_artist_songs_df}} to return a tidy data frame.

Other artist: 
\code{\link{get_artist_df}()},
\code{\link{get_artist_songs_df}()},
\code{\link{get_artist}()}
}
\concept{artist}
