% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/artists.R
\name{get_artist}
\alias{get_artist}
\title{Retrieve metadata for an artist}
\usage{
get_artist(artist_id, access_token = genius_token())
}
\arguments{
\item{artist_id}{ID of the artist (\code{artist_id} within an object returned by
\code{\link{search_artist}})}

\item{access_token}{Genius' client access token, defaults to \code{genius_token}}
}
\value{
a \code{genius_artist} object that contains the extracted content from the request,
the original JSON response object and the request path.
}
\description{
The Genius API lets you return data for a specific artist, given an artist ID.
\code{get_artist} returns this data in full.
}
\examples{
\dontrun{
get_artist(artist_id = 16775)
}
}
\seealso{
See \code{\link{get_artist_df}} to return a tidy data frame.

Other artist: 
\code{\link{get_artist_df}()},
\code{\link{get_artist_songs_df}()},
\code{\link{get_artist_songs}()}
}
\concept{artist}
