% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acuttfn.R
\name{acuttfn}
\alias{acuttfn}
\title{Alpha-cut of triangular fuzzy number}
\usage{
acuttfn(left, middle, right, acut.level = seq(0, 1, by = 0.1))
}
\arguments{
\item{left}{the left point of triangular fuzzy number}

\item{middle}{the middle or mode point of triangular fuzzy number}

\item{right}{the right point of triangular fuzzy number}

\item{acut.level}{the alpha-cut level of triangular fuzzy number}
}
\value{
\code{AL} is alpha-cut level,
            \code{XL.AL} is a lower alpha-cut point of triangular fuzzy number,
        and \code{XU.AL} is a upper alpha-cut point of triangular fuzzy number.
}
\description{
This function for calculating alpha-cut of triangular fuzzy number. See detail in references.
}
\examples{
acuttfn(1,2,3,acut.level = c(0,0.5,1))
acuttfn(1,2.5,3,acut.level = c(0.00,0.25,0.50,0.75,1.00))
}
\references{
Klir, G.J., Yuan, B., & H., S.C.U. (1997). Fuzzy set theory: Foundations and applications. Prentice Hall PTR.
}
