% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sets.R
\name{setops}
\alias{setops}
\alias{intersect}
\alias{union}
\alias{setdiff}
\alias{setequal}
\alias{is.element}
\title{Set operations}
\usage{
intersect(x, y, ...)

union(x, y, ...)

setdiff(x, y, ...)

setequal(x, y, ...)

is.element(el, set, ...)
}
\arguments{
\item{x, y}{Vectors to combine.}

\item{...}{Other arguments passed on to methods.}

\item{el, set}{Element and set to compare.}
}
\value{
For \code{union()}, \code{intersect()}, and \code{setdiff()}, a vector with all
duplicate removed.

For \code{setequal()} and \code{is.element()},  a logical \code{TRUE} or \code{FALSE}.`
}
\description{
Union (\code{union()}), intersect (\code{intersect()}), difference (\code{setdiff()}),
and equality (\code{setequal()}) for two vectors representing sets. Determine
membership with \code{is.element()}.
}
\details{
These functions override the set functions provided in base to make them
generic so that packages can provide methods for different data types. The
default methods call the base versions.
}
\section{Methods}{


\subsection{\code{intersect()}}{
\Sexpr[stage=render,results=rd]{generics:::methods_rd("intersect")}
}

\subsection{\code{union()}}{
\Sexpr[stage=render,results=rd]{generics:::methods_rd("union")}
}

\subsection{\code{setdiff()}}{
\Sexpr[stage=render,results=rd]{generics:::methods_rd("setdiff")}
}

\subsection{\code{setequal()}}{
\Sexpr[stage=render,results=rd]{generics:::methods_rd("setequal")}
}

\subsection{\code{is.element()}}{
\Sexpr[stage=render,results=rd]{generics:::methods_rd("is.element")}
}
}

\examples{
intersect(1:5, 4:8)
union(1:5, 4:8)

setdiff(1:5, 4:8)
setdiff(4:8, 1:5)
}
