% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/abs_stdres.R
\name{abs_stdres}
\alias{abs_stdres}
\title{Absolute values of residuals of kernel regressions of x on y when both x and
y are standardized.}
\usage{
abs_stdres(x, y)
}
\arguments{
\item{x}{{vector of data on the dependent variable}}

\item{y}{{data on the regressors which can be a matrix}}
}
\value{
absolute values of kernel regression residuals are returned after
standardizing the data on both sides so that the magnitudes of residuals are
comparable between regression of x on y on the one hand and regression of y
on x on the other.
}
\description{
1) standardize the data to force mean zero and variance unity, 2) kernel
regress x on y, with the option `residuals = TRUE' and finally 3) compute
the absolute values of residuals.
}
\details{
The first argument is assumed to be the dependent variable.  If
\code{abs_stdres(x,y)} is used, you are regressing x on y (not the usual y
on x). The regressors can be a matrix with 2 or more columns. The missing values
are suitably ignored by the standardization.
}
\examples{

\dontrun{
set.seed(330)
x=sample(20:50)
y=sample(20:50)
abs_stdres(x,y)
}

}
\author{
Prof. H. D. Vinod, Economics Dept., Fordham University, NY
}
\references{
Vinod, H. D."Generalized Correlation and Kernel Causality with
 Applications in Development Economics" in Communications in
 Statistics -Simulation and Computation, 2015,
 \url{http://dx.doi.org/10.1080/03610918.2015.1122048}
}
\keyword{kern}
\keyword{regression}
\keyword{residuals}

