% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genInfo.R
\name{genInfo}
\alias{genInfo}
\title{Get gene related information}
\usage{
genInfo(id = NULL, org = "hs", unique = FALSE)
}
\arguments{
\item{id}{Gene id (symbol, ensembl or entrez id) or uniprot id. If this argument is NULL, return all gene info.}

\item{org}{Latin organism shortname from `ensOrg_name`. Default is human.}

\item{unique}{Logical, if one-to-many mapping occurs, only keep one record with fewest NA. Default is FALSE.}
}
\value{
A `data.frame`.
}
\description{
Get gene related information
}
\examples{
\donttest{
# example1: input list with fake id and one-to-many mapping id
x = genInfo(id = c(
  "MCM10", "CDC20", "S100A9", "MMP1", "BCC7",
  "FAKEID", "TP53", "HBD", "NUDT10"))

# example2: statistics of human gene biotypes
genInfo(org = 'hs') \%>\% {table(.$gene_biotype)}

}
}
