% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/genderizeBootstrapError.R
\name{genderizeBootstrapError}
\alias{genderizeBootstrapError}
\title{Gender prediction errors on bootstrap samples}
\usage{
genderizeBootstrapError(x, y, givenNamesDB, probs, counts,
  num_bootstraps = 50, parallel = FALSE)
}
\arguments{
\item{x}{A text vector that we want to genderize}

\item{y}{A text vector of true gender labels for x vector}

\item{givenNamesDB}{A dataset with gender data (could be an output of \code{findGivenNames} function)}

\item{probs}{A numeric vector of different probability values.
Used to subseting a givenNamesDB dataset}

\item{counts}{A numeric vector of different count values.
Used to subseting a givenNamesDB dataset}

\item{num_bootstraps}{Number of bootstrap samples. Default is 50.}

\item{parallel}{It is passed to \code{genderizeTrain} function. If TRUE it computes errors with the use of \code{parallel} package and available cores. It is design to work on windows machines. Default is FALSE.}
}
\value{
A list of bootstrap errors:
  \item{apparent}{Apparent Error Rate}
  \item{loo_boot}{LOO-Boot Error Rate}
  \item{errorRate632plus}{.632+ Error Rate}
}
\description{
\code{genderizeBootstrapError} calculates the Apparent Error Rate, the Leave-One-Out bootstrap error rate  and the .632+ error rate from Efron and Tibishirani (1997). The code is modified version of several functions from \code{sortinghat} package by John A.Ramey.
}
\examples{
\dontrun{

x = c('Alex', 'Darrell', 'Kale', 'Lee', 'Robin', 'Terry', rep('Robin', 20))
y = c('female', 'female', 'female', 'female', 'female', 'female', rep('male', 20))
givenNamesDB = findGivenNames(x)
classificatonErrors(labels = y,predictions = y)
probs = seq(from =  0.5, to = 0.9, by = 0.05)
counts = c(1)
set.seed(23)
genderizeBootstrapError(x = x, y = y, givenNamesDB = givenNamesDB,
probs = probs, counts = counts, num_bootstraps = 20, parallel = TRUE)
$apparent
[1] 0.9230769
$loo_boot
[1] 0.9401709
$errorRate632plus
[1] 0.9336006

}
}
\seealso{
In the \code{sortinghat} package: \code{\link[sortinghat]{errorest_apparent}} \code{\link[sortinghat]{errorest_loo_boot}} \code{\link[sortinghat]{errorest_632plus}}
}

