[![Build Status](https://travis-ci.org/jcardenas14/genBart.svg?branch=master)](https://travis-ci.org/jcardenas14/genBart)
<h2 style = "text-align: center">genBart</h2>

#### Overview
The goal of `genBart` is to streamline the process of statistical analysis in 
high dimensional studies (e.g. RNA-seq and microarray) to a final and 
comprehensive results object that can be uploaded into the BART (Biostatistical 
Analysis Reporting Tool) shiny app. The app provides users with tools to 
interactively visualize and efficiently sift through large amounts of data and 
results. 

The `genBart` package accomplishes its goal by providing a set of functions 
that modularize every step of the analysis workflow: 

1. Summary stats and quality control
2. Unsupervised analysis (heat maps and cluster analysis)
3. DGE (differential gene expression)
4. Gene set analysis
5. Correlation analysis

Though one strength of BART is its ability to report the entire analysis
workflow in one session, it is often useful to use BART before all of the 
analysis is completed (e.g. viewing heat maps before any statistical analysis is 
run). `genBart` makes this possible by allowing users to easily update and/or 
add to existing BART result objects. Conveniently, BART will only populate with 
tools based on the information contained in the object generated by `genBart`.

#### Installation

You can install genBART from github with:

```r
# install.packages("devtools")
devtools::install_github("jcardenas14/genBart")
```

#### Example

I demonstrate a simple example below of how BART can be used for unsupervised 
analysis. The data used for this example is available in `genBart` and is taken 
from a longitudinal microarray experiment monitoring the gene expression changes 
in cynomolgus macaques infected with *M.tuberculosis* (Skinner et al.). To speed 
up the hierarchical clustering step, I randomly selected a subset (1000) of the 
probes for the example. Please see the [genBart vignette](vignettes/genbart-vignette.Rmd) 
for a full analysis workflow walk-through from the same microarray study.

``` r
## Call data
library(genBart)
data(tb.expr)
data(tb.design)

# declare design information
meta <- metaData(y = tb.expr, design = tb.design, data.type = "microarray", 
                 columnname = "columnname", long = TRUE, 
                 subject.id = "monkey_id", baseline.var = "timepoint", 
                 baseline.val = 0, time.var = "timepoint", sample.id = "sample_group")
                    
# normalize data and cluster  
norm.data <- normalizeData(meta = meta, norm.method = "mean")
dendros <- clusterData(norm.data = norm.data)

# create BART result object
genFile(meta = list(meta), dendrograms = dendros, project.name = "TB Unsupervised Analysis")
```
