/*
 * Decompiled with CFR 0.152.
 */
package gov.lanl.yadas;

import gov.lanl.yadas.TunablePerturber;
import java.util.Random;

public class InterceptSlopePerturber
implements TunablePerturber {
    int[] which;
    double[] mss;
    double[] xbar;
    static Random rand = new Random();

    public InterceptSlopePerturber(int[] which, double[] mss, double[] xbar) {
        this.which = which;
        this.mss = mss;
        this.xbar = xbar;
    }

    public void perturb(double[][] candarray, int whoseTurn) {
        if (this.xbar[whoseTurn] == 0.0) {
            return;
        }
        double temp = this.mss[whoseTurn] * rand.nextGaussian();
        if (Math.abs(this.xbar[whoseTurn]) >= 1.0) {
            double[] dArray = candarray[this.which[0]];
            int n = whoseTurn;
            dArray[n] = dArray[n] + temp;
            double[] dArray2 = candarray[this.which[1]];
            int n2 = whoseTurn;
            dArray2[n2] = dArray2[n2] - temp / this.xbar[whoseTurn];
        } else {
            double[] dArray = candarray[this.which[0]];
            int n = whoseTurn;
            dArray[n] = dArray[n] + temp * this.xbar[whoseTurn];
            double[] dArray3 = candarray[this.which[1]];
            int n3 = whoseTurn;
            dArray3[n3] = dArray3[n3] - temp;
        }
    }

    public int numTurns() {
        return this.mss.length;
    }

    public double jacobian() {
        return 1.0;
    }

    public double[] getStepSizes() {
        double[] tem = new double[this.mss.length];
        System.arraycopy(this.mss, 0, tem, 0, this.mss.length);
        return tem;
    }

    public void setStepSize(double s, int i) {
        this.mss[i] = s;
    }

    public void setStepSizes(double[] s) {
        System.arraycopy(s, 0, this.mss, 0, s.length);
    }
}

