/*
 * Decompiled with CFR 0.152.
 */
package org.drugis.mtc.parameterization;

import edu.uci.ics.jung.algorithms.transformation.FoldingTransformerFixed;
import edu.uci.ics.jung.graph.UndirectedGraph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections15.CollectionUtils;
import org.apache.commons.collections15.Predicate;
import org.drugis.mtc.model.Study;
import org.drugis.mtc.model.Treatment;
import org.drugis.mtc.parameterization.CompareUtil;
import org.drugis.mtc.parameterization.InconsistencyParameterization;
import org.drugis.mtc.parameterization.Partition;
import org.drugis.mtc.parameterization.TreatmentComparator;
import org.drugis.mtc.search.SearchProblem;

public class InconsistencyBaselineSearchProblem
implements SearchProblem<Map<Study, Treatment>> {
    private final Collection<Study> d_studies;
    private final UndirectedGraph<Treatment, FoldingTransformerFixed.FoldedEdge<Treatment, Study>> d_cGraph;
    private final Map<Partition, Set<List<Treatment>>> d_cycleClasses;

    public InconsistencyBaselineSearchProblem(Collection<Study> studies, UndirectedGraph<Treatment, FoldingTransformerFixed.FoldedEdge<Treatment, Study>> cGraph) {
        this(studies, cGraph, null);
    }

    public InconsistencyBaselineSearchProblem(Collection<Study> studies, UndirectedGraph<Treatment, FoldingTransformerFixed.FoldedEdge<Treatment, Study>> cGraph, Map<Partition, Set<List<Treatment>>> cycleClasses) {
        this.d_studies = studies;
        this.d_cGraph = cGraph;
        this.d_cycleClasses = cycleClasses;
    }

    @Override
    public Map<Study, Treatment> getInitialState() {
        HashMap<Study, Treatment> state = new HashMap<Study, Treatment>();
        for (Study s : this.d_studies) {
            Set<Treatment> treatments = s.getTreatments();
            if (treatments.size() != 2) continue;
            state.put(s, CompareUtil.findLeast(treatments, TreatmentComparator.INSTANCE));
        }
        return state;
    }

    @Override
    public List<Map<Study, Treatment>> getSuccessors(final Map<Study, Treatment> state) {
        Study study = CollectionUtils.find(this.d_studies, new Predicate<Study>(){

            @Override
            public boolean evaluate(Study study) {
                return !state.containsKey(study);
            }
        });
        if (study == null) {
            return Collections.emptyList();
        }
        Set<Treatment> treatments = study.getTreatments();
        ArrayList<Map<Study, Treatment>> succ = new ArrayList<Map<Study, Treatment>>(treatments.size());
        for (Treatment treatment : treatments) {
            HashMap<Study, Treatment> map = new HashMap<Study, Treatment>(state);
            map.put(study, treatment);
            succ.add(map);
        }
        return succ;
    }

    @Override
    public boolean isGoal(Map<Study, Treatment> state) {
        if (!state.keySet().containsAll(this.d_studies)) {
            return false;
        }
        HashSet<FoldingTransformerFixed.FoldedEdge<Treatment, Study>> covered = new HashSet<FoldingTransformerFixed.FoldedEdge<Treatment, Study>>();
        for (Map.Entry<Study, Treatment> entry : state.entrySet()) {
            Treatment t0 = entry.getValue();
            for (Treatment t1 : entry.getKey().getTreatments()) {
                FoldingTransformerFixed.FoldedEdge edge = (FoldingTransformerFixed.FoldedEdge)this.d_cGraph.findEdge(t0, t1);
                if (edge == null) continue;
                covered.add(edge);
            }
        }
        if (this.d_cycleClasses == null) {
            return covered.containsAll(this.d_cGraph.getEdges());
        }
        for (Map.Entry<Object, Object> entry : this.d_cycleClasses.entrySet()) {
            Set cycles = (Set)entry.getValue();
            if (this.existsTooManyMissing(cycles, covered)) {
                return false;
            }
            if (!InconsistencyParameterization.isInconsistencyCycle((Partition)entry.getKey()) || this.existsNoneMissing(cycles, covered)) continue;
            return false;
        }
        return true;
    }

    private boolean existsNoneMissing(Set<List<Treatment>> cycles, final Set<FoldingTransformerFixed.FoldedEdge<Treatment, Study>> covered) {
        return CollectionUtils.exists(cycles, new Predicate<List<Treatment>>(){

            @Override
            public boolean evaluate(List<Treatment> cycle) {
                return InconsistencyBaselineSearchProblem.this.countMissingEdges(cycle, covered) == 0;
            }
        });
    }

    private boolean existsTooManyMissing(Set<List<Treatment>> cycles, final Set<FoldingTransformerFixed.FoldedEdge<Treatment, Study>> covered) {
        return CollectionUtils.exists(cycles, new Predicate<List<Treatment>>(){

            @Override
            public boolean evaluate(List<Treatment> cycle) {
                return InconsistencyBaselineSearchProblem.this.countMissingEdges(cycle, covered) < -1;
            }
        });
    }

    private int countMissingEdges(List<Treatment> cycle, Set<FoldingTransformerFixed.FoldedEdge<Treatment, Study>> covered) {
        int missing = 0;
        for (int i = 1; i < cycle.size(); ++i) {
            FoldingTransformerFixed.FoldedEdge edge = (FoldingTransformerFixed.FoldedEdge)this.d_cGraph.findEdge(cycle.get(i - 1), cycle.get(i));
            if (covered.contains(edge)) continue;
            ++missing;
        }
        return missing;
    }
}

