/*
 * Decompiled with CFR 0.152.
 */
package org.drugis.common.threading.activity;

import java.util.Collections;
import java.util.List;
import org.drugis.common.threading.Task;
import org.drugis.common.threading.activity.Transition;

public class DirectTransition
implements Transition {
    private final Task d_source;
    private final Task d_target;

    public DirectTransition(Task source, Task target) {
        this.d_source = source;
        this.d_target = target;
    }

    @Override
    public List<Task> getSources() {
        return Collections.singletonList(this.d_source);
    }

    @Override
    public List<Task> getTargets() {
        return Collections.singletonList(this.d_target);
    }

    @Override
    public boolean isReady() {
        return this.d_source.isFinished();
    }

    @Override
    public List<Task> transition() {
        if (!this.isReady()) {
            throw new RuntimeException("Not ready for transition.");
        }
        return Collections.singletonList(this.d_target);
    }
}

