/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.analysis.function;

import org.apache.commons.math3.analysis.DifferentiableUnivariateFunction;
import org.apache.commons.math3.analysis.UnivariateFunction;
import org.apache.commons.math3.util.FastMath;

public class Sinc
implements DifferentiableUnivariateFunction {
    private static final double SHORTCUT = 1.0E-9;
    private final boolean normalized;

    public Sinc() {
        this(false);
    }

    public Sinc(boolean normalized) {
        this.normalized = normalized;
    }

    public double value(double x) {
        if (this.normalized) {
            double piTimesX = Math.PI * x;
            return Sinc.sinc(piTimesX);
        }
        return Sinc.sinc(x);
    }

    public UnivariateFunction derivative() {
        if (this.normalized) {
            return new UnivariateFunction(){

                public double value(double x) {
                    double piTimesX = Math.PI * x;
                    return Sinc.sincDerivative(piTimesX);
                }
            };
        }
        return new UnivariateFunction(){

            public double value(double x) {
                return Sinc.sincDerivative(x);
            }
        };
    }

    private static double sinc(double x) {
        return FastMath.abs(x) < 1.0E-9 ? 1.0 : FastMath.sin(x) / x;
    }

    private static double sincDerivative(double x) {
        return FastMath.abs(x) < 1.0E-9 ? 0.0 : (FastMath.cos(x) - FastMath.sin(x) / x) / x;
    }
}

