% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_XHiY.R
\name{calc_XHiY}
\alias{calc_XHiY}
\title{Calculate XHiY}
\usage{
calc_XHiY(eval, D_l, X, UltVehiY)
}
\arguments{
\item{eval}{vector of eigenvalues from the decomposition of the relatedness matrix}

\item{D_l}{vector of length d_size}

\item{X}{design matrix}

\item{UltVehiY}{a matrix}
}
\value{
numeric vector
}
\description{
Calculate XHiY
}
\examples{
readr::read_tsv(system.file("extdata",
"mouse100.pheno.txt",
package = "gemma2"),
col_names = FALSE) -> pheno
phe16 <- as.matrix(pheno[, c(1, 6)])
as.matrix(readr::read_tsv(system.file("extdata",
"mouse100.cXX.txt",
package = "gemma2"),
col_names = FALSE)[, 1:100]) -> kinship
eigen2(kinship) -> eout
eout$values -> eval
eout$vectors -> U
UltVehi <- matrix(c(0, -1.76769, -1.334414, 0),
nrow = 2,
byrow = FALSE) # from output of eigen_proc()
calc_XHiY(eval = eval,
D_l = c(0.9452233, 5.9792268),
          X = rep(1, 100) \%*\% U,
          UltVehiY = UltVehi \%*\% t(phe16) \%*\% U
          )
}
