% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.geolmStd.R
\name{predict.geolmStd}
\alias{predict.geolmStd}
\title{Predict method for geostatistical models}
\usage{
\method{predict}{geolmStd}(object, newdata, nsim = 0, sp = TRUE,
  dmethod = "chol", ...)
}
\arguments{
\item{object}{An object produced by the \code{geolm} function.}

\item{newdata}{An optional data frame in which to look for the coordinates at which to predict. If omitted, the observed data locations are used.}

\item{nsim}{A non-negative integer indicating the number of realizations to sample at the specified coordinates using conditional simulation.}

\item{sp}{A logical value indicating whether to object returned should be of class \code{\link[sp]{SpatialPointsDataFrame}} for easier plotting with the \code{sp} package.  Default is \code{TRUE}.}

\item{dmethod}{The method used to decompose the covariance matrix for conditional simulation.  Valid options are \code{"chol"}, \code{"eigen"}, and \code{"svd"}.  The default is \code{"chol"}.}

\item{...}{Currently unimplemented.}
}
\value{
If \code{sp = TRUE}, then a \code{SpatialPointDataFrame} from the \code{sp} package is returned, with components including the prediction coordinates, the predicted responses \code{pred}, the mean square prediction error (\code{mspe}), the root mean square prediction error (\code{rmspe}), and the conditional realizations, if application (\code{sim.1}, \code{sim.2}, ...).  If \code{sp = FALSE}, then a list of class \code{gearKrige} is returned, with components \code{pred}, \code{mspe}, \code{rmspe}, and \code{sim}, if relevant.
}
\description{
\code{predict} calculates the predicted values at specified locations.  The method can additionally provide the mean square prediction error (mspe) and perform conditional simulation.
}
\details{
The \code{newdata} data frame must include the relevant covariates for the prediction locations, where the covariates are specified on the right side of the \code{~} in \code{object$formula}.  \code{newdata} must also include the coordinates of the prediction locations, with these columns having the names provided in \code{object$coordnames}.
}
\examples{

# generate response
y = rnorm(10)
# generate coordinates
x1 = runif(10); x2 = runif(10)

# data frame for observed data
data = data.frame(y, x1, x2)
# newdata must have columns with prediction coordinates
newdata = data.frame(x1 = runif(5), x2 = runif(5))

# specify a standard covariance model
cmod = cmod.std(model = "exponential", psill = 1, 
                r = 1)

# geolm for universal kriging
gearmod_uk = geolm(y ~ x1 + x2, data = data,
                 coordnames = c("x1", "x2"),
                 cmod = cmod)
# prediction for universal kriging, with conditional simulation
pred_uk = predict(gearmod_uk, newdata, nsim = 2)

# geolm for ordinary kriging
gearmod_ok = geolm(y ~ 1, data = data,
                 coordnames = c("x1", "x2"),
                 cmod = cmod)
# prediction for ordinary kriging
pred_ok = predict(gearmod_ok, newdata)

# geolm for simple kriging
gearmod_ok = geolm(y ~ 1, data = data,
                 coordnames = c("x1", "x2"),
                 cmod = cmod, mu = 1)
# prediction for simple kriging
pred_sk = predict(gearmod_ok, newdata)

}
\author{
Joshua French
}

