% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/robustdisc.R
\name{robust_disc}
\alias{robust_disc}
\title{univariate discretization based on offline change point detection}
\usage{
robust_disc(formula, data, discnum, minsize = 1, cores = 1)
}
\arguments{
\item{formula}{A formula of univariate discretization.}

\item{data}{A data.frame or tibble of observation data.}

\item{discnum}{A numeric vector of discretized classes of columns that need to be discretized.}

\item{minsize}{(optional) The min size of each discretization group. Default all use \code{1}.}

\item{cores}{(optional) A positive integer(default is 1). If cores > 1, use \code{python} \code{joblib} package to
parallel computation.}
}
\value{
A tibble of discretized columns which need to be discretized.
}
\description{
Determines discretization interval breaks using an optimization algorithm for variance-based
change point detection.
}
\note{
Please set up python dependence and configure \code{GDVERSE_PYTHON} environment variable if you want to run \code{robust_disc()}.
See \code{vignette('rgdrid',package = 'gdverse')} for more details.
}
\examples{
\dontrun{
## The following code needs to configure the Python environment to run:
data('ndvi')
robust_disc(NDVIchange ~ GDP,data = ndvi,discnum = 5)
robust_disc(NDVIchange ~ .,
            data = dplyr::select(ndvi,-c(Climatezone,Mining)),
            discnum = 10,cores = 6)
}
}
\author{
Wenbo Lv \email{lyu.geosocial@gmail.com}
}
