gqi.odfpeaklines <-
function(gdi="gqi", fbase=NULL, roi=NULL,  rg=c(1,1), swap=FALSE, lambda=NULL, depth=3, btoption=2, threshold=0.4, kdir=2, zfactor=5, showglyph=FALSE, showimage="linesgfa", bview="coronal", savedir=tempdir(), bg="white", texture=NULL, aniso=NULL, ...)
{
  gdimethods <- c("gqi", "gqi2")
  gdimethod <- match(gdi, gdimethods)
  showimages <- c("none", "gfa", "lines", "linesgfa", "linesrgbmap", "linesdata") ## map types
  kshow <- match(showimage, showimages)
  stopifnot(is.na(kshow) != TRUE)
  bviews <- c("sagittal", "coronal", "axial")
  kv <- match(bview, bviews)
  stopifnot(is.na(kv) != TRUE)
  ##---------
  # generate S2 grid
  s2 <- s2tessel.zorder(depth=depth, viewgrid=FALSE)
  odfvertices <- s2$pc
  tcsurf <- s2$tcsurf
  ##-----------
  ## Read data
  testfilexist(fbase=fbase, btoption=btoption)
  if(btoption == 1) { ## Option 1: S2-shell (DSI 203-point 3mm)
    btable <- as.matrix(
      readtable(fbase=fbase, filename="btable.txt"))
  }
  else {
    if(btoption == 2) { ## Option 2: 3D-dsi grid 
      bval <- scantable(fbase=fbase, filename="data.bval")
      # bvec <- readtable(fbase=fbase, filename="data.bvec")
      bvec <- scantable(fbase=fbase, filename="data.bvec")
      bvec <- matrix(bvec, ncol=3)
      btable <- cbind(bval,bvec)
      rm(bval, bvec)
    }
    else stop()
  }
  ##----------------------------
  gc()
  cat("Reading data ...\n")
  ptm <- proc.time()
  niifile  <- readniidata(fbase=fbase, filename="data.nii.gz")
  volimg <- nifti.image.read(niifile)
  if(is.null(roi)) {
    niimask <- readniidata(fbase=fbase, filename="data_brain_mask.nii.gz")
    volmask <- nifti.image.read(niimask)
  }
  else {
    niimask <- readniidata(fbase=fbase, filename=roi)
    volmask <- nifti.image.read(niimask)
  }
  print(proc.time() - ptm)
  d <- dim(volimg)
  dm <- dim(volmask)
  if(is.null(rg)) {
    switch(kv,
      { nslices <- d[1]}, # sagittal,
      { nslices <- d[2]}, # coronal
      { nslices <- d[3]}) # axial
    first <- 1; last <- nslices
  }
  else {
    nslices <- diff(rg)+1
    rx <- rg[1]:rg[2]
    switch(kv,
      { d[1] <- nslices; dm[1] <- nslices
        volimg <- volimg[rx,,,];
        volmask <- volmask[rx,,]; }, # sagittal,
      { d[2] <- nslices; dm[2] <- nslices
        volimg <- volimg[,rx,,]; 
        volmask <- volmask[,rx,]; }, # coronal
      { d[3] <- nslices; dm[3] <- nslices
        volimg <- volimg[,,rx,];
        volmask <- volmask[,,rx]; })  # axial
    first <- 1; last <- nslices
  }
  volimg <- array(volimg, dim=d)
  volmask <- array(volmask, dim=dm)
  gc()
  ##-----------------------------
  ## "gdimethod" process
  cat("Estimating slice odfs ...\n")
  switch(gdimethod,
    q2odf <- gqifn(odfvert=odfvertices, btable=btable,
                   lambda=lambda),
    q2odf <- gqifn2(odfvert=odfvertices, btable=btable,
                   lambda=lambda) )
  ##-----------------------------
  ## store 1st vector directions for each non-thresholded voxel 
  ## v1list: vector of lists
  nv1 <- length(first:last)
  v1list <- vector(mode="list", nv1)
  ## rglstart()
  for (sl in (first:last)) {
    cat("slice",sl,"; ")
    slicedata <- read.slice(img=volimg, mask=volmask, slice=sl, swap=swap, bview=bview)
    ymaskdata <- premask(slicedata)
    if(ymaskdata$empty) next # empty mask
    odfs <- q2odf %*% (ymaskdata$yn)
    # odfs <- apply(odfs, 2, norm01) ## normalize 
    odfs <- apply(odfs, 2, anisofn, aniso=aniso) 
    gfas <- apply(odfs, 2, genfa)
    gfas <- norm01(gfas) ## ??
    z2d <- ymaskdata$kin
    zx <- which(gfas <= threshold) ## mask out thresholded values
    if(length(zx)) {
      z2d <- z2d[-zx,]
      gfas <- gfas[-zx]
      odfs <- odfs[,-zx]
    }
    if(is.null(dim(z2d))) next
    # if(length(gfas) < 2) next # 2 elements as minimum number
    lix <- dim(z2d)[1]
    switch(kv,
      { nr <- d[2]; nc <- d[3]}, # sagittal,
      { nr <- d[1]; nc <- d[3]}, # coronal
      { nr <- d[1]; nc <- d[2]}) # axial
    nn <- nr*nc
    ck <- numeric(nn)
    v <- matrix(0, nrow=nn, ncol=3)
    q <- 1
    cat(lix,"voxels, ...")
    for(m in 1:lix) {
      odf <- odfs[,m]
      ## find peaks
      odf <- odf[1:(length(odf)/2)] # use half sized odf in findpeak
      pk <- findpeak(odf, t(odfvertices), tcsurf)
      ## optional cross-fiber glyph visualization
      if(showglyph) {
        if(rgl.cur() == 0) rglinit()
        else rgl.clear()
        # if(pk$np > 2) {
          plotglyph(odfs[,m], odfvertices, pk, kdir=kdir, vmfglyph=FALSE)
          pp <- readline(
            "\nmore fiber glyphs  ? ('n' to exit) ") 
          if(pp == "n" ) { rgl.close(); showglyph <- FALSE; }
          else { rgl.clear( type = "shapes" ) }
        # }
      }
      ## directions of max odf values to define (colored) lines
      gk <- gfas[m] 
      pos <- c(z2d[m,],0) # use yy-swapped mask
      for(k in 1:min(pk$np, kdir)) {
        coords <- pk$pcoords
        zch <- coords[,k] * gk
        zch <- t(norm01(abs(zch)))
        if(q+1 > nn) {
          ck <- append(ck , numeric(nn))
          v <- rbind(v,  matrix(0, nrow=nn, ncol=3))
          nn <- nn+nn
        }
        ck[q] <- rgb(zch)
        ck[q+1] <- ck[q]
        pp <- pk$pcoords[,k]/2
        v[q,] <- -pp + pos
        v[q+1,]  <-  pp + pos
        q <- q+2
      }
    }
    cat("\n")
    q <- q-1;  
    v <- v[1:q,]
    ck <- ck[1:q]
    if(kshow != 1){ ## one image per slice
      # rgl.init()
      if(sl == first) {
        rglstart(bg=bg)
      }
      if(kshow > 2) {
        segments3d(v, col=ck, lwd=2, alpha=1)
        rgl.viewpoint(theta=0, phi=15)
        par3d('windowRect'=c(0,0,600,600), 'zoom'=0.6, skipRedraw=FALSE)
        rgl.bringtotop()
      }
      switch(kshow,
      { ovr <- FALSE },
      { ovr <- TRUE; imgfa <- matrix(0, nr, nc); imgfa[z2d ] <- gfas },
      { ovr <- FALSE },
      { ovr <- TRUE; imgfa <- matrix(0, nr, nc); imgfa[z2d ] <- gfas },
      { ovr<- TRUE; zfactor=0.1;
        imgfa <- matrix(0, nr, nc); imgfa[z2d ] <- gfas }, # linesrgb
      { ovr <- TRUE;
      imgfa <- slicedata$niislicets[,,1] * slicedata$mask;
      imgfa <- imgfa/max(imgfa) } )
      if(ovr) {
        bg3d(col=bg) 
        light3d()  
        gfasurf3d(imgfa, zfactor=zfactor, alpha=0.6, texture=texture, ...)
        rgl.viewpoint(theta=0, phi=15)
        par3d('windowRect'=c(0,0,600,600), 'zoom'=0.6, skipRedraw=FALSE)
        rgl.bringtotop()
      }
    }
    if(sl != last) {
      pp <- readline("continue to next 'rg' slice ? ('n' to exit) ") 
      if(pp == "n" ) { break; }
      else { rgl.clear( type = "shapes" ) }
    }
  }
  cat("\n")
}

