% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gdi.r
\name{cscorr}
\alias{cscorr}
\title{Measure and analyze cross-sectional geometry}
\usage{
cscorr(
  image_file,
  threshold = 0.5,
  channel = 4,
  method = "greater",
  return = "area_corr",
  k = 2,
  scale = 1
)
}
\arguments{
\item{image_file}{Image to be read. Images can be jpeg or png files, or a previously read image saved as an object in R.}

\item{threshold}{Reference value for colour criterium after which pixels that are part of the cross-section are differentiated from the background.}

\item{channel}{Colour channel to which to apply the threshold criterium. Default is 4 (alpha channel of rgba image). Channel setting needs to be adjusted depending on the colour mode of the image used (e.g. there are two channels to choose from in a greyscale image, and 3 in an rgb image).}

\item{method}{Method for determining which pixels to count. Default "greater" counts pixels with value greater than threshold (e.g. higher opacity, in the case of an alpha channel). "less" counts pixels with a value less than the threshold. "not" counts all pixels not precisely matching threshold. Any other character string results in only pixels exactly matching the value given as threshold being counted.}

\item{return}{What value to return. Possible values are "area_corr" (Default, returns ratio between measured area and area of ellipse with same horizontal and vertical diameters), "aspect_ratio" (returns aspect ratio), "diameters" (returns diameters) and "area" (returns area). Any other value for this parameter will prompt the function to return a vector containing all of these.}

\item{k}{optional superellipse exponent for the (super)ellipse to which the measurements should be compared (for the "area_corr" setting for the parameter return).}

\item{scale}{Optional scale of the image (for raw area measurements).}
}
\value{
Either a numeric of length 1 (depending on the input of the return parameter), defaulting to the area correction factor (if return=="area_corr"), or (if return is left empty or does not match any of the predefined settings) a numeric vector of length 5 containing all the possible outputs (x and y diameters, aspect ratio, area and area correction factor).
}
\description{
Measure and analyze cross-sectional geometry
}
\examples{
fdir <- system.file(package="gdi")
correction_factor <- cscorr(file.path(fdir,"exdata","cross_section.png"))
}
