% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom.R
\name{g_distance}
\alias{g_distance}
\title{Compute the distance between two geometries}
\usage{
g_distance(this_geom, other_geom)
}
\arguments{
\item{this_geom}{Character. OGC WKT string for a simple feature geometry.}

\item{other_geom}{Character. OGC WKT string for a simple feature geometry.}
}
\value{
Numeric. Distance or '-1' if an error occurs.
}
\description{
\code{g_distance()} returns the distance between two geometries or \code{-1} if an
error occurs. Returns the shortest distance between the two geometries.
The distance is expressed into the same unit as the coordinates of the
geometries.
}
\note{
Geometry validity is not checked. In case you are unsure of the validity
of the input geometries, call \code{g_is_valid()} before, otherwise the result
might be wrong.
}
\examples{
g_distance("POINT (0 0)", "POINT (5 12)")
}
