% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/image_collection.R
\name{image_collection}
\alias{image_collection}
\title{Load an existing image collection from a file}
\usage{
image_collection(path)
}
\arguments{
\item{path}{path to an existing image collection file}
}
\value{
an image collection proxy object, which can be used to create a data cube using \code{\link{raster_cube}}
}
\description{
This function will load an image collection from an SQLite file. Image collection files
index and reference existing imagery. To create a collection from files on disk,
use \code{\link{create_image_collection}}.
}
\examples{
# create image collection from example Landsat data only 
# if not already done in other examples
if (!file.exists(file.path(tempdir(), "L8.db"))) {
  L8_files <- list.files(system.file("L8NY18", package = "gdalcubes"),
                         ".TIF", recursive = TRUE, full.names = TRUE)
  create_image_collection(L8_files, "L8_L1TP", file.path(tempdir(), "L8.db"), quiet = TRUE) 
}

L8.col = image_collection(file.path(tempdir(), "L8.db"))
L8.col
}
